% L = gating
% KX = dissociation constant for agonist (uM)
% KD = dissociation constant for drug (uM)
% c = effect of agonist on gating
% d = effect of drug on gating
% b = effect of drug on agonist binding
% X = agonist concentration (M)
% D = drug concentration (M)
PA_RA = @(L, KX, KD, c, d, b, X, D) 1 ./ (1 + L .* ((1+X./(KX*1e-6)).^2 + D./(KD*1e-6).*(1+X./(b*KX*1e-6)).^2) ./ ((1+X./(c*KX*1e-6)).^2 + D./(d*KD*1e-6).*(1+X./(b*c*KX*1e-6)).^2));

PA_RAx = @(x, X, D) PA_RA(x(1), x(2), x(3), x(4), x(5), x(6), X, D);

GABA_M = logspace(-11, -0, 100);
DZ_M = logspace(-11, -0, 100);

WT_GABA_Po = 0.85 ./ (1 + (24e-6 ./ GABA_M).^1.17);
WT_GABA_NPo = WT_GABA_Po ./ max(WT_GABA_Po);

V279A_GABA_Po = 0.85 ./ (1 + (116e-6 ./ GABA_M).^0.78);
V279A_GABA_NPo = V279A_GABA_Po ./ max(V279A_GABA_Po);

L9T_GABA_Po = 0.36 + 0.64 ./ (1 + (0.25e-6 ./ GABA_M).^0.83);
L9T_GABA_NPo = L9T_GABA_Po - min(L9T_GABA_Po);
L9T_GABA_NPo = L9T_GABA_NPo ./ max(L9T_GABA_NPo);

L9T_V279A_GABA_Po = 0.18 + 0.82 ./ (1 + (0.23e-6 ./ GABA_M).^1.44);
L9T_V279A_GABA_NPo = L9T_V279A_GABA_Po - min(L9T_V279A_GABA_Po);
L9T_V279A_GABA_NPo = L9T_V279A_GABA_NPo ./ max(L9T_V279A_GABA_NPo);

L9T_DZ_Po = 0.36 + 0.36 * 0.35 ./ (1 + (85e-9 ./ DZ_M).^1.10);
L9T_DZ_NPo = L9T_DZ_Po - min(L9T_DZ_Po);
L9T_DZ_NPo = L9T_DZ_NPo ./ max(L9T_DZ_NPo);

L9T_V279A_DZ_Po = 0.18 + 0.18 * 2 ./ (1 + (110e-9 ./ DZ_M).^0.98);
L9T_V279A_DZ_NPo = L9T_V279A_DZ_Po - min(L9T_V279A_DZ_Po);
L9T_V279A_DZ_NPo = L9T_V279A_DZ_NPo ./ max(L9T_V279A_DZ_NPo);

% Fit WT, V279A, L9T and L9T/V279A
%      L     KX  KD   c     d    b L9  L9V dV
x0 = [ 1.8e4 82  0.1  0.002 0.45 1 1.8 4.6 0.1 ];
lb = [ 1.8e4 1   0.01 1e-5  0.35 1 0.1 0.1 0.2 ];
ub = [ 1.8e4 300 10   1     0.99 1 10  10  0.9 ];
LF = 1e4;
cost = @(x) sum((WT_GABA_Po - PA_RAx([x(7)*LF x([2:6])], GABA_M, 0)).^2)./numel(GABA_M) ...
    ...%+ sum((V279A_GABA_NPo .* max(PA_RAx([x(8)*1e4 x([2:4 9 6])], GABA_M, 0)) - PA_RAx([x(8)*1e4 x([2:4 9 6])], GABA_M, 0)).^2)./numel(GABA_M) ...
    + sum((L9T_GABA_NPo.*max(PA_RAx(x([7 2:6]), GABA_M, 0)).*(1-min(L9T_GABA_Po))   + max(PA_RAx(x([7 2:6]), GABA_M, 0))*min(L9T_GABA_Po) - PA_RAx(x([7 2:6]), GABA_M, 0)).^2)./numel(GABA_M) ...
    + sum((L9T_DZ_NPo  .*max(PA_RAx(x([7 2:6]), GABA_M, 0)).*(0.35*min(L9T_GABA_Po)) + max(PA_RAx(x([7 2:6]), GABA_M, 0))*min(L9T_GABA_Po) - PA_RAx(x([7 2:6]), 0, DZ_M)).^2)./numel(DZ_M) ...
    + sum((L9T_V279A_GABA_NPo.*max(PA_RAx(x([8 2:4 9 6]), GABA_M, 0)).*(1-min(L9T_V279A_GABA_Po)) + max(PA_RAx(x([8 2:4 9 6]), GABA_M, 0))*min(L9T_V279A_GABA_Po) - PA_RAx(x([8 2:4 9 6]), GABA_M, 0)).^2)./numel(GABA_M) ...
    + sum((L9T_V279A_DZ_NPo  .*max(PA_RAx(x([8 2:4 9 6]), GABA_M, 0)).*(2*min(L9T_V279A_GABA_Po)) + max(PA_RAx(x([8 2:4 9 6]), GABA_M, 0))*min(L9T_V279A_GABA_Po) - PA_RAx(x([8 2:4 9 6]), 0, DZ_M)).^2)./numel(DZ_M) ...
    ;
opt = optimset( ...
    'MaxFunEvals', 1e9 * numel(x0), ...
    'MaxIter', 1e9 * numel(x0) ...
    );
[x,fval,exitflag,output] = fminsearchbnd(@(x)cost(x), x0, lb, ub, opt);
output
tmp = num2cell(x);
[L,KX,KD,c,d,b,L9,L9V,dV] = deal(tmp{:});
L = L9 * 1e4;
LV = L * L9V / L9;
fprintf(' L=%f\n KX=%f uM\n KD=%f uM\n c=%f\n d=%f\n b=%f\n L9=%f\n L9V=%f\n dV=%f\n', L,KX,KD,c,d,b,L9,L9V,dV);



D = 1e-6;

WT_GABA_Pofit = PA_RA(L,KX,KD,c,d,b, GABA_M, 0);

V279A_GABA_Pofit = PA_RA(LV,KX,KD,c,dV,b, GABA_M, 0);
V279A_GABA_Po = V279A_GABA_NPo .* max(V279A_GABA_Pofit);

L9T_GABA_Pofit = PA_RA(L9,KX,KD,c,d,b, GABA_M, 0);
L9T_GABA_Po = L9T_GABA_NPo .* max(L9T_GABA_Pofit) .* (1-min(L9T_GABA_Po)) + max(L9T_GABA_Pofit) * min(L9T_GABA_Po);

L9T_V279A_GABA_Pofit = PA_RA(L9V,KX,KD,c,dV,b, GABA_M, 0);
L9T_V279A_GABA_Po = L9T_V279A_GABA_NPo .* max(L9T_V279A_GABA_Pofit) .* (1-min(L9T_V279A_GABA_Po)) + max(L9T_V279A_GABA_Pofit) * min(L9T_V279A_GABA_Po);

L9T_DZ_Pofit = PA_RA(L9,KX,KD,c,d,b, 0, DZ_M);
L9T_DZ_Po = L9T_DZ_NPo .* max(L9T_GABA_Pofit) .* 0.35.* min(L9T_GABA_Po) + max(L9T_GABA_Pofit) * min(L9T_GABA_Po);

L9T_V279A_DZ_Pofit = PA_RA(L9V,KX,KD,c,dV,b, 0, DZ_M);
L9T_V279A_DZ_Po = L9T_V279A_DZ_NPo .* max(L9T_V279A_GABA_Pofit) .* 2 .* min(L9T_V279A_GABA_Po) + max(L9T_V279A_GABA_Pofit) * min(L9T_V279A_GABA_Po);

WT_GABA_Po_inDZfit = PA_RA(L,KX,KD,c,d,b, GABA_M, D);

V279A_GABA_Po_inDZfit = PA_RA(LV,KX,KD,c,dV,b, GABA_M, D);



% figure;
subplot(2,2,1); cla; hold on;
plot(log10(GABA_M), L9T_GABA_Po, '-');
plot(log10(GABA_M), L9T_V279A_GABA_Po, '--');
plot(log10(GABA_M), L9T_GABA_Pofit, '-', 'linewidth', 2);
plot(log10(GABA_M), L9T_V279A_GABA_Pofit, '--', 'linewidth', 2);
xlim([-10 -3]);
ylim([0 1]);
xlabel('log10(GABA)');
ylabel('Po');
title('');

subplot(2,2,2); cla; hold on;
plot(log10(DZ_M), L9T_DZ_Po, '-');
plot(log10(DZ_M), L9T_V279A_DZ_Po, '--');
plot(log10(DZ_M), L9T_DZ_Pofit, '-', 'linewidth', 2);
plot(log10(DZ_M), L9T_V279A_DZ_Pofit, '--', 'linewidth', 2);
xlim([-10 -3]);
ylim([0 1]);
xlabel('log10(DZ)');
ylabel('Po');

subplot(2,2,3); cla; hold on;
plot(log10(GABA_M), WT_GABA_Pofit, '-');
plot(log10(GABA_M), WT_GABA_Po_inDZfit, '-', 'linewidth', 2);
xlim([-8 -1]);
ylim([0 1]);
xlabel('log10(GABA)');
ylabel('Po');

subplot(2,2,4); cla; hold on;
plot(log10(GABA_M), V279A_GABA_Pofit, '--');
plot(log10(GABA_M), V279A_GABA_Po_inDZfit, '--', 'linewidth', 2);
xlim([-8 -1]);
ylim([0 1]);
xlabel('log10(GABA)');
ylabel('Po');


%%

pot_d = PA_RA(LV, KX, KD, c, d, b, 30e-3, 1e-6) / PA_RA(LV, KX, KD, c, d, b, 30e-3, 0)
pot_dV = PA_RA(LV, KX, KD, c, dV, b, 30e-3, 1e-6) / PA_RA(LV, KX, KD, c, dV, b, 30e-3, 0)

