import numpy as np

D = 30 # in micron**2/min
doubling_time = np.arange(2,24,0.5) # in hours
r = np.log(2)/(doubling_time*60) # in 1/min
a = np.arange(0.1,2,0.01) # in micron/min

A,R = np.meshgrid(a,r)

SIGMA = (A + R*D/A)*(A>np.sqrt(D*R)) + 2*np.sqrt(D*R)*(A<=np.sqrt(D*R))

# Saving data

# Loading data.npz
data_dic = dict(np.load('../../data.npz'))
# Replacing data
data_dic['doubling_time_D'] = doubling_time
data_dic['a_D'] = a
data_dic['r_D'] = r
data_dic['A_D'] = A
data_dic['R_D'] = R
data_dic['SIGMA_D'] = SIGMA
# Saving present data.npz
np.savez('../../data.npz',**data_dic)


