import numpy as np
import matplotlib.pyplot as plt

lsize=20

fig,ax=plt.subplots(nrows=3,ncols=2,figsize=(22,15))

# Loading data

data = np.load("data.npz")

# Subfigure A

axA=ax[0,0]

N_data = data["N_data_AB"] # saved frames of the evolution of rho. shape : 200x2500
rho_data = data["rho_data_AB"] # saved frames of the evolution of N. shape : 200x2500

rho = rho_data[130,:] # taking the 130th saved frame
N = N_data[130,:] # taking the 130th saved frame

L = 2.5
I = 2500

X=np.linspace(0,L,I)
plt.rc('text', usetex=True)
color = 'black'
axA.set_xlabel(r'\textit{Distance from center (mm})',size=lsize)
axA.set_ylabel(r'\textit{Cell density $\rho$ (cell/mm$^{-2}$)}', color=color,size=lsize)
axA.plot(X, rho, color=color)
axA.set_ylim(0,3000)
axA.set_xlim(0,1.5)
axA.tick_params(axis='y', labelcolor=color,labelsize=lsize)
axA.tick_params(axis='x',labelsize=lsize)
color = 'black'
color = 'red'
axAbis = axA.twinx()
axAbis.plot(X,N, label=r'Oxygen concentration C ($\%$)', color=color)
axAbis.set_ylabel(r'\textit{Oxygen concentration C ($\%$)}', color=color,size=lsize)
axAbis.set_ylim(0,11)
axAbis.set_xlim(0,1.5)
axAbis.tick_params(axis='y', labelcolor=color,labelsize=lsize)

# Subfigure B

axB=ax[0,1]

time = np.linspace(0,10,200)
dist = np.linspace(0,1.3,326)

heatmapB = axB.pcolormesh(dist,time,rho_data[::-1,:1304:4],shading='auto')
barB = fig.colorbar(heatmapB, ax=axB, shrink = 1)
barB.ax.tick_params(labelsize=lsize)
barB.ax.set_yticklabels(['0','','1000','','2000',''], size=lsize)
barB.set_label(r'  \textit{Cell density  $\rho$ (cell/mm$^{-2}$)}', size=lsize, rotation = 90)

y1 = [0,2,4,6,8,10]
y1labels = ["10","8","6","4","2","0"]
axB.set_yticks(y1)
axB.set_yticklabels(y1labels, size=lsize)
x1 = [0,0.25,0.5,0.75,1,1.25]
x1labels = ["0","0.25","0.5","0.75","1","1.25"]
axB.set_xticks(x1)
axB.set_xticklabels(x1labels, size=lsize)

axB.set_xlabel(r'\textit{Distance from center (mm)}',size=lsize)
axB.set_ylabel(r'\textit{Time (hours)}',size=lsize)

# Subfigure C

axC=ax[1,0]

A0 = 1000*data["A0_C"] # values of aertoactic advection speed a0
Speed2 = 1000*data["Speed_C"] # corresponding numerical speed of waves in the two-threshold case

#N_data = data["N_data_C"]
#rho_data = data["rho_data_C"]
#Position = data["Position_C"]
#Mean_speed = data["Mean_speed_C"]

r = np.log(2)/440
Drho = 30

Speed1=np.maximum(np.sqrt(r*Drho),A0)+r*Drho/np.maximum(np.sqrt(r*Drho),A0)

axC.set_ylabel(r'\textit{Wave speed $\sigma$ (\textmu m/min)}',size=lsize)
axC.set_xlabel(r'\textit{Aerotactic bias $a_0$ (\textmu m/min)}',size=lsize)
axC.plot(A0, Speed1,color='black',ls='-', label='Single threshold')
axC.plot(A0, Speed2,color='black',ls='--', label='Double threshold')
axC.set_ylim(0,2.2)
axC.tick_params(axis='y',labelsize=lsize)
axC.tick_params(axis='x',labelsize=lsize)
axCbis = axC.twinx()
color = 'blue'
axCbis.set_ylim(0,25)
axCbis.set_xlim(0,2.1)
axCbis.tick_params(axis='y', labelcolor=color,labelsize=lsize)
axCbis.set_ylabel(r'\textit{Relative difference (\%)}',color=color,size=lsize)
axCbis.plot(A0, 100*np.abs(Speed1-Speed2)/Speed1,'+',color=color,label='relative difference')

axC.legend(fontsize=lsize)

# Subfigure D

D = 30
doubling_time = data["doubling_time_D"]
a = data["a_D"] # line-array of values for aertoactic advection speed a0 (in micron/min)
r = data["r_D"] # line-array of values for cell division rate r (in micron/min)
# A,R = np.meshgrid(a,r)
A = data["A_D"]
R = data["R_D"]
# SIGMA = (A + R*D/A)*(A>np.sqrt(D*R)) + 2*np.sqrt(D*R)*(A<=np.sqrt(D*R))
SIGMA = data["SIGMA_D"]

axD=ax[1,1]

heatmapD = axD.pcolormesh(a,doubling_time,2*np.sqrt(D*R)/SIGMA,shading='auto')
barD = fig.colorbar(heatmapD, ax=axD)
barD.ax.set_yticklabels(['0.2','','0.4','','0.6','','0.8','','1.0'], size=lsize)
barD.set_label(r'  \textit{Fraction $\varphi$}', size=lsize, rotation = 90)
axD.contour(a,doubling_time,2*np.sqrt(D*R)/SIGMA,[.99])
axD.set_xlabel(r'\textit{Aerotactic bias $a_0$ (\textmu m/min)}', size=lsize)
axD.set_ylabel(r'\textit{Doubling time (hours)}', size=lsize)
axD.set_xticks([0.5, 1 , 1.5])
axD.set_xticklabels(["0.5","1","1.5"],size=lsize)
axD.set_yticks([4, 8 , 12, 16, 20])
axD.set_yticklabels(["4","8","12","16","20"],size=lsize)

# Subfigure E

axE=ax[2,0]

N_data = data["N_data_E"] # saved frames of the evolution of rho. shape : 50x3000
rho_data = data["rho_data_E"] # saved frames of the evolution of N. shape : 50x9000

rho = rho_data[49,:] # taking the 49th saved frame
N = N_data[49,:] # taking the 49th saved frame

L = 9
Lrho = 3
I = 9000
Irho = 3000

X=np.linspace(0,Lrho,Irho)
plt.rc('text', usetex=True)
color = 'black'
axE.set_xlabel(r'\textit{Distance from center (mm})',size=lsize)
axE.set_ylabel(r'\textit{Cell density $\rho$ (cell/mm$^{-2}$)}', color=color,size=lsize)
axE.plot(X, rho, color=color)
axE.set_ylim(0,200)
axE.set_xlim(1,2.5)
axE.tick_params(axis='y', labelcolor=color,labelsize=lsize)
axE.tick_params(axis='x',labelsize=lsize)
color = 'black'
color = 'red'
axEbis = axE.twinx()
axEbis.plot(X,N[:Irho], label=r'Oxygen concentration C ($\%$)', color=color)
axEbis.set_ylabel(r'\textit{Oxygen concentration C ($\%$)}', color=color,size=lsize)
axEbis.set_ylim(0,5)
axEbis.set_xlim(1,2.5)
axEbis.tick_params(axis='y', labelcolor=color,labelsize=lsize)

# Subfigure F

axF=ax[2,1]

N_data = data["N_data_F"] # saved frames of the evolution of rho. shape : 50x3000
rho_data = data["rho_data_F"] # saved frames of the evolution of N. shape : 50x9000

rho = rho_data[35,:] # taking the 35th saved frame
N = N_data[35,:] # taking the 35th saved frame

L = 9
Lrho = 3
I = 9000
Irho = 3000

X=np.linspace(0,Lrho,Irho)
plt.rc('text', usetex=True)
color = 'black'
axF.set_xlabel(r'\textit{Distance from center (mm})',size=lsize)
axF.set_ylabel(r'\textit{Cell density $\rho$ (cell/mm$^{-2}$)}', color=color,size=lsize)
axF.plot(X, rho, color=color)
axF.set_ylim(0,200)
axF.set_xlim(1,2.5)
axF.tick_params(axis='y', labelcolor=color,labelsize=lsize)
axF.tick_params(axis='x',labelsize=lsize)
color = 'black'
color = 'red'
axFbis = axF.twinx()
axFbis.plot(X,N[:Irho], label=r'Oxygen concentration C ($\%$)', color=color)
axFbis.set_ylabel(r'\textit{Oxygen concentration C ($\%$)}', color=color,size=lsize)
axFbis.set_ylim(0,5)
axFbis.set_xlim(1,2.5)
axFbis.tick_params(axis='y', labelcolor=color,labelsize=lsize)

# Saving figure

fig.tight_layout(pad=3)

fig.savefig('Fig6.png',dpi=300)







