import numpy as np
import matplotlib.pyplot as plt

lsize=15

fig,ax=plt.subplots(nrows=4,ncols=3,figsize=(15,15))
plt.rc('text', usetex=True)

# Loading data

data = np.load("data.npz")

L = 9 # length of domain [0,L mm]
Lrho = 3 # length of domain for rho. We shortened it, in order to speed up the simulations
I = 9000 # dx=1micron
Irho = 3000 # dx=1micron
Ninit = 21 # initial oxygen concentration
K = 2000 # auxiliary variable for plotting
X=np.linspace(0,Lrho,Irho)
Z = np.linspace(0,Ninit,K)

# Subfigure A

axA0=ax[0,0]
axA1=ax[0,1]
axA2=ax[0,2]

#N_data = data["N_data_A"] # saved frames of the evolution of N. shape : 50x9000
#rho_data = data["rho_data_A"] # saved frames of the evolution of N. shape : 50x3000
N = data["N_A"] # Oxygen profile
rho = data["rho_A"] # Cell density profile
chi_profile_N = data["chi_profile_N_A"] # Aerotactic advection profile as a function of N
r_profile_N = data["r_profile_N_A"] # Cell division rate profile as a function of N
r_profile_space = data["r_profile_space_A"] # Cell division rate profile as a function of x

## Plot Advection profile

color = "blue"
axA0.set_ylabel(r'\textit{$a$ (\textmu m   min$^{-1}$)', color=color, size=lsize)
axA0.set_xlabel(r'\textit{C ($\%$)}', size=lsize)
axA0.plot(Z, chi_profile_N, color=color)
axA0.tick_params(axis='y', labelcolor=color)
axA0.set_ylim(0, 1.5*np.max(chi_profile_N))
axA0.set_xlim(0,2)

## Plot Cell division profile

color = "green"
axA1.set_ylabel(r'\textit{$r$ (min$^{-1}$)', color=color, size=lsize)
axA1.set_xlabel(r'\textit{C ($\%$)}', size=lsize)
axA1.plot(Z, r_profile_N, color=color)
axA1.tick_params(axis='y', labelcolor=color)
axA1.set_ylim(0, 1.5*np.max(r_profile_N))
axA1.set_xlim(0,2)

## Plot Cell and Oxygen profiles

color = 'black'
axA2.set_xlabel(r'\textit{Distance from centre (\textmu m})',size=lsize)
axA2.set_ylabel(r'\textit{Cell density $\rho$ (cell/mm$^{-2}$)}', color=color,size=lsize)
axA2.plot(X, rho, color=color)
axA2.set_ylim(0,200)
axA2.set_xlim(.5,2.5)
axA2.tick_params(axis='y', labelcolor=color,labelsize=lsize)
axA2.tick_params(axis='x', labelcolor=color,labelsize=lsize)
axA2bis = axA2.twinx()
color = 'red'
axA2bis.set_ylabel(r'\textit{Oxygen concentration C (\%)}', color=color,size=lsize)
axA2bis.plot(X, N[:Irho], color=color)
axA2bis.set_ylim(0,7)
axA2bis.set_xlim(.5,2.5)
axA2bis.tick_params(axis='y', labelcolor=color,labelsize=lsize)
color = 'green'
axA2bis.plot(X, 3*r_profile_space[:Irho]/np.max(r_profile_space), color=color,label=r'Cell division (min$^{-1}$)')
axA2bis.legend(loc=1,fontsize=lsize)

# Subfigure B

axB0=ax[1,0]
axB1=ax[1,1]
axB2=ax[1,2]

#N_data = data["N_data_B"] # saved frames of the evolution of N. shape : 50x9000
#rho_data = data["rho_data_B"] # saved frames of the evolution of N. shape : 50x3000
N = data["N_B"] # Oxygen profile
rho = data["rho_B"] # Cell density profile
chi_profile_N = data["chi_profile_N_B"] # Aerotactic advection profile as a function of N
r_profile_N = data["r_profile_N_B"] # Cell division rate profile as a function of N
r_profile_space = data["r_profile_space_B"] # Cell division rate profile as a function of x

## Plot Advection profile

color = "blue"
axB0.set_ylabel(r'\textit{$a$ (\textmu m   min$^{-1}$)', color=color, size=lsize)
axB0.set_xlabel(r'\textit{C ($\%$)}', size=lsize)
axB0.plot(Z, chi_profile_N, color=color)
axB0.tick_params(axis='y', labelcolor=color)
axB0.set_ylim(0, 1.5*np.max(chi_profile_N))
axB0.set_xlim(0,2)

## Plot Cell division profile

color = "green"
axB1.set_ylabel(r'\textit{$r$ (min$^{-1}$)', color=color, size=lsize)
axB1.set_xlabel(r'\textit{C ($\%$)}', size=lsize)
axB1.plot(Z, r_profile_N, color=color)
axB1.tick_params(axis='y', labelcolor=color)
axB1.set_ylim(0, 1.5*np.max(r_profile_N))
axB1.set_xlim(0,2)

## Plot Cell and Oxygen profiles

color = 'black'
axB2.set_xlabel(r'\textit{Distance from centre (\textmu m})',size=lsize)
axB2.set_ylabel(r'\textit{Cell density $\rho$ (cell/mm$^{-2}$)}', color=color,size=lsize)
axB2.plot(X, rho, color=color)
axB2.set_ylim(0,200)
axB2.set_xlim(.5,2.5)
axB2.tick_params(axis='y', labelcolor=color,labelsize=lsize)
axB2.tick_params(axis='x', labelcolor=color,labelsize=lsize)
axB2bis = axB2.twinx()
color = 'red'
axB2bis.set_ylabel(r'\textit{Oxygen concentration C (\%)}', color=color,size=lsize)
axB2bis.plot(X, N[:Irho], color=color)
axB2bis.set_ylim(0,7)
axB2bis.set_xlim(.5,2.5)
axB2bis.tick_params(axis='y', labelcolor=color,labelsize=lsize)
color = 'green'
axB2bis.plot(X, 3*r_profile_space[:Irho]/np.max(r_profile_space), color=color,label=r'Cell division (min$^{-1}$)')
axB2bis.legend(loc=1,fontsize=lsize)

# Subfigure C

axC0=ax[2,0]
axC1=ax[2,1]
axC2=ax[2,2]

#N_data = data["N_data_C"] # saved frames of the evolution of N. shape : 50x9000
#rho_data = data["rho_data_C"] # saved frames of the evolution of N. shape : 50x3000
N = data["N_C"] # Oxygen profile
rho = data["rho_C"] # Cell density profile
lambda_profile_N = data["lambda_profile_N_C"] # Aerotactic strength (ie : a=lambda*d_x N) profile as a function of N
r_profile_N = data["r_profile_N_C"] # Cell division rate profile as a function of N
r_profile_space = data["r_profile_space_C"] # Cell division rate profile as a function of x

## Plot Advection profile

color = "blue"
axC0.set_ylabel(r'\textit{$\lambda$ (\textmu m$^2$   min$^{-1}\%^{-1}$)', color=color, size=lsize)
axC0.set_xlabel(r'\textit{C ($\%$)}', size=lsize)
axC0.plot(Z, lambda_profile_N, color=color)
axC0.tick_params(axis='y', labelcolor=color)
axC0.set_ylim(0, 1.5*np.max(lambda_profile_N))
axC0.set_xlim(0,2)

## Plot Cell division profile

color = "green"
axC1.set_ylabel(r'\textit{$r$ (min$^{-1}$)', color=color, size=lsize)
axC1.set_xlabel(r'\textit{C ($\%$)}', size=lsize)
axC1.plot(Z, r_profile_N, color=color)
axC1.tick_params(axis='y', labelcolor=color)
axC1.set_ylim(0, 1.5*np.max(r_profile_N))
axC1.set_xlim(0,2)

## Plot Cell and Oxygen profiles

color = 'black'
axC2.set_xlabel(r'\textit{Distance from centre (\textmu m})',size=lsize)
axC2.set_ylabel(r'\textit{Cell density $\rho$ (cell/mm$^{-2}$)}', color=color,size=lsize)
axC2.plot(X, rho, color=color)
axC2.set_ylim(0,200)
axC2.set_xlim(.5,2.5)
axC2.tick_params(axis='y', labelcolor=color,labelsize=lsize)
axC2.tick_params(axis='x', labelcolor=color,labelsize=lsize)
axC2bis = axC2.twinx()
color = 'red'
axC2bis.set_ylabel(r'\textit{Oxygen concentration C (\%)}', color=color,size=lsize)
axC2bis.plot(X, N[:Irho], color=color)
axC2bis.set_ylim(0,7)
axC2bis.set_xlim(.5,2.5)
axC2bis.tick_params(axis='y', labelcolor=color,labelsize=lsize)
color = 'green'
axC2bis.plot(X, 3*r_profile_space[:Irho]/np.max(r_profile_space), color=color,label=r'Cell division (min$^{-1}$)')
axC2bis.legend(loc=1,fontsize=lsize)

# Subfigure D

axD0=ax[3,0]
axD1=ax[3,1]
axD2=ax[3,2]

#N_data = data["N_data_D"] # saved frames of the evolution of N. shape : 50x9000
#rho_data = data["rho_data_D"] # saved frames of the evolution of N. shape : 50x3000
N = data["N_D"] # Oxygen profile
rho = data["rho_D"] # Cell density profile
mu_profile_N = data["mu_profile_N_D"] # Logarithmic aerotactic strength (ie : a=mu*d_x N/N) profile as a function of N
r_profile_N = data["r_profile_N_D"] # Cell division rate profile as a function of N
r_profile_space = data["r_profile_space_D"] # Cell division rate profile as a function of x

## Plot Advection profile

color = "blue"
axD0.set_ylabel(r'\textit{$\mu$ (\textmu m$^2$   min$^{-1}$)', color=color, size=lsize)
axD0.set_xlabel(r'\textit{C ($\%$)}', size=lsize)
axD0.plot(Z, mu_profile_N, color=color)
axD0.tick_params(axis='y', labelcolor=color)
axD0.set_ylim(0, 1.5*np.max(mu_profile_N))
axD0.set_xlim(0,2)

## Plot Cell division profile

color = "green"
axD1.set_ylabel(r'\textit{$r$ (min$^{-1}$)', color=color, size=lsize)
axD1.set_xlabel(r'\textit{C ($\%$)}', size=lsize)
axD1.plot(Z, r_profile_N, color=color)
axD1.tick_params(axis='y', labelcolor=color)
axD1.set_ylim(0, 1.5*np.max(r_profile_N))
axD1.set_xlim(0,2)

## Plot Cell and Oxygen profiles

color = 'black'
axD2.set_xlabel(r'\textit{Distance from centre (\textmu m})',size=lsize)
axD2.set_ylabel(r'\textit{Cell density $\rho$ (cell/mm$^{-2}$)}', color=color,size=lsize)
axD2.plot(X, rho, color=color)
axD2.set_ylim(0,200)
axD2.set_xlim(.5,2.5)
axD2.tick_params(axis='y', labelcolor=color,labelsize=lsize)
axD2.tick_params(axis='x', labelcolor=color,labelsize=lsize)
axD2bis = axD2.twinx()
color = 'red'
axD2bis.set_ylabel(r'\textit{Oxygen concentration C (\%)}', color=color,size=lsize)
axD2bis.plot(X, N[:Irho], color=color)
axD2bis.set_ylim(0,7)
axD2bis.set_xlim(.5,2.5)
axD2bis.tick_params(axis='y', labelcolor=color,labelsize=lsize)
color = 'green'
axD2bis.plot(X, 3*r_profile_space[:Irho]/np.max(r_profile_space), color=color,label=r'Cell division (min$^{-1}$)')
axD2bis.legend(loc=1,fontsize=lsize)

# Saving figure

fig.tight_layout(pad=3)

fig.savefig('FigSI17.png',dpi=200)




