import numpy as np
import matplotlib.pyplot as plt

plt.rc('text', usetex=True)
lsize = 20

Drho = 3/(10**5)

# Loading data

data = np.load("data.npz")

a = data["a"] # line-array of values for aertoactic advection speed a0 (in mm/min)
doubling_time = data["doubling_time"]
R = data["R"] # Meshgrid-array of values for cell division rate r (in mm/min)
SIGMA = data["SIGMA"] # implicit speed for special two-threshold model for given parameters A,R (see MM : Mathematical analysis of a specific ‘Go or Grow’ model with a second threshold)

fig,ax = plt.subplots(figsize=(10,8))

heatmap = ax.pcolormesh(a,doubling_time,(2*np.sqrt(Drho*R))/SIGMA,shading='auto',vmin = 0, vmax=1)
bar = fig.colorbar(heatmap, ax=ax)
bar.ax.tick_params(labelsize=lsize)
bar.ax.set_yticklabels(['0','0.2','0.4','0.6','0.8','1.0'], size=lsize)
bar.set_label(r'  \textit{Fraction $\varphi$}', size=lsize, rotation = 90)
ax.plot(a,np.log(2)/(60*a**2/Drho), color="black")
ax.set_xlim(0.1/1000,1.9/1000)
ax.set_ylim(2,23)
ax.set_xlabel(r'\textit{Aerotactic bias $a_0$ (\textmu m/min)}', size=lsize)
ax.set_ylabel(r'\textit{Doubling time (hours)}', size=lsize)
ax.set_xticks([0.5/1000, 1/1000 , 1.5/1000])
ax.set_xticklabels(["0.5","1","1.5"],size=lsize)
ax.set_yticks([4,8,12,16,20])
ax.set_yticklabels(["4","8","12","16","20"],size=lsize)

fig.savefig("FigSI19.png",dpi=300)
