library(phyloseq)
library(reshape2)

setwd("Path/to/PhyloseqObject")
load("DropletPlate_subsampled_filtered.RData", verbose=TRUE)


# median normalization

total <- median(sample_sums(DropletPlate_subsampled_filtered))
standf <- function(x, t=total) round(t * (x / sum(x)))
DropletPlate_subsampled_filtered_normed <- transform_sample_counts(DropletPlate_subsampled_filtered, standf)


# sample subsetting

dp<-subset_samples(DropletPlate_subsampled_filtered_normed, sampleType %in% c("droplet_sample", "plate_sample"))
dp_rel<-transform_sample_counts(dp, function(x) x / sum(x) )


# peparing a data frame

dp_df<-psmelt(dp_rel) 
dp_df_wide<-dcast(dp_df, sampleType + Sample ~ OTU, value.var="Abundance", fun.aggregate=sum) 


# filter out empty Taxa

weg<-(colSums(dp_df_wide[,3:length(dp_df_wide)]) == 0)

dp_df_wide_w<-dp_df_wide
dp_df_wide_w[,c(1,2)]<-NULL 

dp_df_wide_clean <- dp_df_wide_w[, !weg]

dp_df_wide_clean$Sample<-0 
dp_df_wide_clean$SampleType<-0

dp_df_wide_clean$SampleType<-dp_df_wide[,1]
dp_df_wide_clean$Sample<-dp_df_wide[,2]
dp_df_wide_clean<-dp_df_wide_clean[,c(length(dp_df_wide_clean),length(dp_df_wide_clean)-1, 1:(length(dp_df_wide_clean)-2))] 


# export data frame to MS Excel

write.csv(dp_df_wide_clean, file="Figure3c_data.csv", row.names=TRUE)
write.csv(tax_table(dp_df), file="Figure3c_Tax_data.csv", row.names = TRUE)

# Figure3c_data.csv was used in MS Excel for determining the taxa found in droplets or plates
# resulting lists of taxa were used to create Venn diagrams: http://bioinformatics.psb.ugent.be/webtools/Venn/
# Figure3c_Tax_data.csv was used to transfer full taxonomy to the exclusive droplet/plate taxa
