library(ggplot2)
theme_set(theme_bw())

setwd("Path/to/PhyloseqObject")

data<-read.csv("Figure5_data.csv", header=TRUE, sep=";")
data$phylum<-c("Actinobacteria", "Firmicutes", "Proteobacteria", "Proteobacteria", "Firmicutes", "Actinobacteria", "Actinobacteria", "Actinobacteria", "Actinobacteria", "Firmicutes", "Bacteroidetes")

isolate<-ggplot(data)+
  geom_bar(aes(x=data$Genus,y=data$rel..Abund, fill=factor(data$phylum)), stat="identity", width=0.5)+
  ylim(0,60)+
  coord_flip()+
  labs(y="relative Abundance [%]", x="Genus", fill="Phylum") +
  theme(axis.text=element_text(size=10), axis.text.y = element_text(face = "italic"), axis.title=element_text(size=10))+
  theme(legend.text=element_text(face="italic"))+
  geom_text(aes(x=data$Genus, y=data$rel..Abund, label=round(data$rel..Abund, digits=1), hjust=-0.3))+
  theme(legend.direction = "horizontal", legend.position = c(0.415, 1.06), legend.title=element_text(size=11))+
  theme(plot.margin = unit(c(1,0,0,0), "cm"))+
  theme(legend.key = element_rect(colour="white"))
isolate
ggsave(file="Figure5.svg", plot=isolate, height=8, width=12, units="cm", pointsize=10)