library(reshape2)
library(plyr)
library(ggplot2)
theme_set(theme_bw())

setwd("Path/to/PhyloseqObject")

data<-read.csv("Figure6_data.csv", header=TRUE, sep=";")

data_count<-count(data, vars = c("Plotorder", "Experiment", "order"))

data_total<-count(data_count, vars = c("Plotorder","Experiment"))

data_count$relative<-0
data_count$relative[1:7]<-data_count$freq[1:7]/data_total$freq[1]
data_count$relative[8:17]<-data_count$freq[8:17]/data_total$freq[2]
data_count$relative[18:29]<-data_count$freq[18:29]/data_total$freq[3]
data_count$relative[30]<-data_count$freq[30]/data_total$freq[4]

data_count$Plotorder<-as.factor(data_count$Plotorder)
my.colors<-c('#d95f02',"#5E738F",'#66a61e',"#f768a1",'#7570b3','#e6ab02','#1b9e77', "#CD9BCD","#49006a", "#00441b", "#C84248", "#8569D5", '#e7298a')

order.g<-ggplot(data_count, aes(x=Plotorder, y=relative, fill=order)) + 
  geom_bar(stat="identity", width=0.5) +
  labs(y="rel. Abundance [%]") +
  theme(axis.text.x  = element_text(angle=45, vjust=0.95, hjust=0.95, size=10), axis.title.x = element_blank())+
  theme(legend.text=element_text(face="italic"))+
  scale_fill_manual(values = my.colors) +
  scale_x_discrete(breaks=unique(data_count$Plotorder), labels=unique(data_count$Experiment))
order.g
ggsave(file="Figure6.svg", plot=order.g, height=8, width=10, units="cm", pointsize=10)

