function [] = figure1HIJKL()

% load the data
dd = load('dataHIJKL.mat');
meanA = dd.meanA;
meanS = dd.meanS;
anglesS = dd.anglesS;
totalA = dd.totalA;
totalS = dd.totalS;

% determine explicit angles
iA = meanA;
iS = meanS;
tA = totalA;
tS = totalS;
eA = tA - iA;
eS = tS - iS;

% average across all blocks in abrupt condition
iA = mean(iA);
eA = mean(eA);

% the rotations
rA = 60*ones(size(iA));
rS = repmat([15;30;45;60],1,size(iS,2));

% the driving force
dA = rA - eA;
dS = rS - eS;

% plot implicit, explicit, and total
figure
subplot(1,5,2)
colors = {'k','m','b','r'};
hold on
for b = 1 : 4
    ii = iS(b,:);
    m = nanmean(ii); %#ok<*NANMEAN>
    s = nanstd(ii) / sqrt(length(ii)); %#ok<*NANSTD>
    bar(b,m,'FaceColor',colors{b},'EdgeColor','k')
    plot([b,b],[m-s,m+s],'Color',colors{b})
end
ylabel('implicit')
title('Figure 1I')

subplot(1,5,3)
hold on
for b = 1 : 4
    ii = eS(b,:);
    m = nanmean(ii);
    s = nanstd(ii) / sqrt(length(ii));
    bar(b,m,'FaceColor',colors{b},'EdgeColor','k')
    plot([b,b],[m-s,m+s],'Color',colors{b})
    plot(b*ones(size(eS(b,:))),eS(b,:),'.k')
end
ylabel('explicit')
title('Figure 1J')

subplot(1,5,4)
hold on
for b = 1 : 4
    ii = dS(b,:);
    m = nanmean(ii);
    s = nanstd(ii) / sqrt(length(ii));
    bar(b,m,'FaceColor',colors{b},'EdgeColor','k')
    plot([b,b],[m-s,m+s],'Color',colors{b})
end
ylabel('driving force (deg)')
title('Figure 1K')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%% competition model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% get the scaling factor (b/1-a+b)
fun = @(x,y,p) sum((x - p*y).^2);

Nstraps = 1000;
iCompA = zeros(Nstraps,1);
iCompS = zeros(4,Nstraps);
ps = zeros(Nstraps,1);
for n = 1 : Nstraps
    % randomly samples participants
    idxA = randsample(length(dA),length(dA),1);
    iiA = nanmean(iA(idxA),2);
    ddA = nanmean(dA(idxA),2);
    idxS = randsample(size(dS,2),size(dS,2),1);
    iiS = nanmean(iS(:,idxS),2);
    ddS = nanmean(dS(:,idxS),2);
    
    % fit the competition model
    i = [iiA ; iiS];
    d = [ddA ; ddS];
    p = fminbnd(@(p)fun(i,d,p),0,1);
    iCompA(n) = ddA * p;
    iCompS(:,n) = ddS * p;
    ps(n) = p;
end

subplot(1,5,5)
hold on
for b = 1 : 4
    ii = iCompS(b,:);
    m = nanmean(ii);
    s = nanstd(ii);
    bar(b,m,'FaceColor','b','EdgeColor','k')
    plot([b,b],[m-s,m+s],'Color','k')
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%% independence model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% get the scaling factor (b/1-a+b)
fun = @(x,y,p) sum((x - p*y).^2);

Nstraps = 1000;
iIndepA = zeros(Nstraps,1);
iIndepS = zeros(4,Nstraps);
for n = 1 : Nstraps
    % randomly samples participants
    idxA = randsample(length(dA),length(dA),1);
    iiA = nanmean(iA(idxA),2);
    rrA = nanmean(rA(idxA),2);
    idxS = randsample(size(dS,2),size(dS,2),1);
    iiS = nanmean(iS(:,idxS),2);
    rrS = nanmean(rS(:,idxS),2);
    
    % fit the competition model
    i = [iiA ; iiS];
    r = [rrA ; rrS];
    p = fminbnd(@(p)fun(i,r,p),0,1);
    iIndepA(n) = rrA * p;
    iIndepS(:,n) = rrS * p;
end

subplot(1,5,5)
hold on
for b = 1 : 4
    ii = iIndepS(b,:);
    m = nanmean(ii);
    s = nanstd(ii);
    bar(b+6,m,'FaceColor','g','EdgeColor','k')
    plot([b+6,b+6],[m-s,m+s],'Color','k')
end

% add the data
% plot implicit, explicit, and total
for b = 1 : 4
    ii = iS(b,:);
    m = nanmean(ii); %#ok<*NANMEAN>
    s = nanstd(ii) / sqrt(length(ii)); %#ok<*NANSTD>
    bar(b-6,m,'FaceColor','k','EdgeColor','k')
    plot([b-6,b-6],[m-s,m+s],'Color','k')
end

ylabel('implicit aftereffect (deg)')
title('Figure 1L')


subplot(1,5,1)
hold on
m = nanmean(anglesS,2);
s = nanstd(anglesS,[],2) / sqrt(size(anglesS,2));
plot(1:66,m(1:66),'-k')
plot(1:66,m(1:66)-s(1:66),'--k')
plot(1:66,m(1:66)+s(1:66),'--k')
plot(66*ones(size(iS(1,:)))+20*rand(size(iS(4,:))) - 10,iS(1,:),'.k')

plot(67:132,m(67:132),'-m')
plot(67:132,m(67:132)-s(67:132),'--m')
plot(67:132,m(67:132)+s(67:132),'--m')
plot(132*ones(size(iS(2,:)))+20*rand(size(iS(4,:))) - 10,iS(2,:),'.m')

plot(133:198,m(133:198),'-b')
plot(133:198,m(133:198)-s(133:198),'--b')
plot(133:198,m(133:198)+s(133:198),'--b')
plot(198*ones(size(iS(3,:)))+20*rand(size(iS(4,:))) - 10,iS(3,:),'.b')

plot(199:264,m(199:end),'-r')
plot(199:264,m(199:end)-s(199:end),'--r')
plot(199:264,m(199:end)+s(199:end),'--r')
plot(264*ones(size(iS(4,:)))+20*rand(size(iS(4,:))) - 10,iS(4,:),'.r')

ax = gca;
ax.TickDir = 'out';
ylabel('reach angle (deg)')
title('Figure 1H')