function [] = figure1MNOPQ()

% load the data
dd = load('dataMNOPQ');
A15 = dd.A15; A30 = dd.A30; A60 = dd.A60; A90 = dd.A90;
angles15 = dd.angles15; angles30 = dd.angles30; angles60 = dd.angles60; angles90 = dd.angles90;
i15 = dd.i15; i30 = dd.i30; i60 = dd.i60; i90 = dd.i90;
e15 = dd.e15; e30 = dd.e30; e60 = dd.e60; e90 = dd.e90;

figure
subplot(1,5,1)
hold on
m15 = nanmean(A15,2);
s15 = nanstd(A15,[],2) / 5;
m30 = nanmean(A30,2);
s30 = nanstd(A30,[],2) / 5;
m60 = nanmean(A60,2);
s60 = nanstd(A60,[],2) / 5;
m90 = nanmean(A90,2);
s90 = nanstd(A90,[],2) / 5;

ii = 15:78;
ms = {m15,m30,m60,m90};
ss = {s15,s30,s60,s90};
is = {i15,i30,i60,i90};
colors = {'k','m','r',[139,69,19]/255};
for g = 1 : 4
    plot(ii,ms{g}(ii),'-','Color',colors{g})
    plot(ii,ms{g}(ii)-ss{g}(ii),'--','Color',colors{g})
    plot(ii,ms{g}(ii)+ss{g}(ii),'--','Color',colors{g})
    plot(78+g*2.5+rand(size(is{g})),is{g},'.','Color',colors{g})
end
ax = gca;
ax.TickDir = 'out';
xlim([15,92])
ylabel('reach angle (deg)')
xlabel('cycle number')
title('Figure 1M')

% plot implicit learning
dd = {i15,i30,i60,i90};
rs = [15,30,60,90];
subplot(1,5,2)
hold on
for g = 1 : 4
    m = nanmean(dd{g});
    s = nanstd(dd{g}) / sqrt(length(dd{g}));
    bar(rs(g),m,10,'FaceColor',colors{g},'EdgeColor','k')
    plot([rs(g),rs(g)],[m-s,m+s],'-k')
end
ax = gca;
ax.TickDir = 'out';
xlabel('rotation (deg)')
ylabel('implicit angle (deg)')
title('Figure 1N')

% plot explicit learning
dd = {e15,e30,e60,e90};
subplot(1,5,3)
hold on
for g = 1 : 4
    m = nanmean(dd{g});
    s = nanstd(dd{g}) / sqrt(length(dd{g}));
    bar(rs(g),m,10,'FaceColor',colors{g},'EdgeColor','k')
    plot([rs(g),rs(g)],[m-s,m+s],'-k')
    plot(rs(g)*ones(size(dd{g})),dd{g},'.k')
end
ax = gca;
ax.TickDir = 'out';
xlabel('rotation (deg)')
ylabel('explicit angle (deg)')
title('Figure 1O')

% the driving force
dd = {15-e15,30-e30,60-e60,90-e90};
rs = [15,30,60,90];
subplot(1,5,4)
hold on
for g = 1 : 4
    m = nanmean(dd{g});
    s = nanstd(dd{g}) / sqrt(length(dd{g}));
    bar(rs(g),m,10,'FaceColor',colors{g},'EdgeColor','k')
    plot([rs(g),rs(g)],[m-s,m+s],'-k')
end
ax = gca;
ax.TickDir = 'out';
xlabel('rotation (deg)')
ylabel('driving force (r - x_e^s^s)')
title('Figure 1P')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%% competition model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% no feedback period
y15 = nanmean(angles15(157:176,:),2);
y30 = nanmean(angles30(157:176,:),2);
y60 = nanmean(angles60(157:176,:),2);
y90 = nanmean(angles90(157:176,:),2);

lb = [-60,0];
ub = [60,1];
fdecay = @(y0,a,tt) y0 * (a*ones(size(tt))) .^ tt;
costfun = @(y0,a,tt,y) sum((y - fdecay(y0,a,tt)).^2);
pars15 = fmincon(@(xx)costfun(xx(1),xx(2),0:19,y15'),[15,0.8],[],[],[],[],lb,ub);
pars30 = fmincon(@(xx)costfun(xx(1),xx(2),0:19,y30'),[15,0.8],[],[],[],[],lb,ub);
pars60 = fmincon(@(xx)costfun(xx(1),xx(2),0:19,y60'),[15,0.8],[],[],[],[],lb,ub);
pars90 = fmincon(@(xx)costfun(xx(1),xx(2),0:19,y90'),[15,0.8],[],[],[],[],lb,ub);

% mean retention
a = pars15(2) + pars30(2) + pars60(2) + pars90(2);
a = a / 4;

% predict the u-shape phenomena
fpredict = @(r,e,a,b) b / (1 - a + b) * (r-e);

% the cost function
costfun = @(r,e,a,b,i) sum((i - fpredict(r,e,a,b)).^2);

% get the average e in each group
e = [nanmean(e15),nanmean(e30),nanmean(e60),nanmean(e90)];
r = [15,30,60,90];
i = [nanmean(i15),nanmean(i30),nanmean(i60),nanmean(i90)];

% search for optimal b
b = fminbnd(@(xx)costfun(r,e,a,xx,i),0,1);

% the optimal p
p = b / (1 - a + b);

% predict implicit in each group
i15model = p * (15 - e15);
i30model = p * (30 - e30);
i60model = p * (60 - e60);
i90model = p * (90 - e90);

% plot the data
subplot(1,5,5)
hold on
m = nanmean(i15);
s = nanstd(i15) / sqrt(length(i15)); %#ok<*NANSTD>
bar(1,m,'FaceColor','k','EdgeColor','k')
plot([1,1],[m-s,m+s],'-k')
m = nanmean(i30);
s = nanstd(i30) / sqrt(length(i30));
bar(2,m,'FaceColor','k','EdgeColor','k')
plot([2,2],[m-s,m+s],'-k')
m = nanmean(i60);
s = nanstd(i60) / sqrt(length(i60));
bar(3,m,'FaceColor','k','EdgeColor','k')
plot([3,3],[m-s,m+s],'-k')
m = nanmean(i90);
s = nanstd(i90) / sqrt(length(i90));
bar(4,m,'FaceColor','k','EdgeColor','k')
plot([4,4],[m-s,m+s],'-k')

% plot the model predictions
m = nanmean(i15model);
s = nanstd(i15model) / sqrt(length(i15model));
bar(6,m,'FaceColor','b','EdgeColor','k')
plot([6,6],[m-s,m+s],'-k')
m = nanmean(i30model);
s = nanstd(i30model) / sqrt(length(i30model));
bar(7,m,'FaceColor','b','EdgeColor','k')
plot([7,7],[m-s,m+s],'-k')
m = nanmean(i60model);
s = nanstd(i60model) / sqrt(length(i60model));
bar(8,m,'FaceColor','b','EdgeColor','k')
plot([8,8],[m-s,m+s],'-k')
m = nanmean(i90model);
s = nanstd(i90model) / sqrt(length(i90model));
bar(9,m,'FaceColor','b','EdgeColor','k')
plot([9,9],[m-s,m+s],'-k')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%% independence model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
lb = [-60,0];
ub = [60,1];
fdecay = @(y0,a,tt) y0 * (a*ones(size(tt))) .^ tt;
costfun = @(y0,a,tt,y) sum((y - fdecay(y0,a,tt)).^2);
pars15 = fmincon(@(xx)costfun(xx(1),xx(2),0:19,y15'),[15,0.8],[],[],[],[],lb,ub);
pars30 = fmincon(@(xx)costfun(xx(1),xx(2),0:19,y30'),[15,0.8],[],[],[],[],lb,ub);
pars60 = fmincon(@(xx)costfun(xx(1),xx(2),0:19,y60'),[15,0.8],[],[],[],[],lb,ub);
pars90 = fmincon(@(xx)costfun(xx(1),xx(2),0:19,y90'),[15,0.8],[],[],[],[],lb,ub);

% mean retention
a = pars15(2) + pars30(2) + pars60(2) + pars90(2);
a = a / 4;

% predict the u-shape phenomena
fpredict = @(r,e,a,b) b / (1 - a + b) * r;

% the cost function
costfun = @(r,e,a,b,i) sum((i - fpredict(r,e,a,b)).^2);

% bootstrap results
numStraps = 10000;
p = zeros(numStraps,1);
for n = 1 : numStraps
    % resample participants in each group
    idx = randsample(25,25,1);
    
    % get the average e in each group
    e = [nanmean(e15(idx)),nanmean(e30(idx)),nanmean(e60(idx)),nanmean(e90(idx))]; %#ok<*NANMEAN>
    r = [15,30,60,90];
    i = [nanmean(i15(idx)),nanmean(i30(idx)),nanmean(i60(idx)),nanmean(i90(idx))];

    % search for optimal b
    b = fminbnd(@(xx)costfun(r,e,a,xx,i),0,1);

    % the optimal p
    p(n) = b / (1 - a + b);
end

% predict implicit in each group
i15model = p * 15;
i30model = p * 30;
i60model = p * 60;
i90model = p * 90;

% plot the model predictions
m = nanmean(i15model);
s = nanstd(i15model);
bar(11,m,'FaceColor','g','EdgeColor','k')
plot([11,11],[m-s,m+s],'-k')
m = nanmean(i30model);
s = nanstd(i30model);
bar(12,m,'FaceColor','g','EdgeColor','k')
plot([12,12],[m-s,m+s],'-k')
m = nanmean(i60model);
s = nanstd(i60model);
bar(13,m,'FaceColor','g','EdgeColor','k')
plot([13,13],[m-s,m+s],'-k')
m = nanmean(i90model);
s = nanstd(i90model);
bar(14,m,'FaceColor','g','EdgeColor','k')
plot([14,14],[m-s,m+s],'-k')

ax = gca;
ax.TickDir = 'out';
ylabel('implicit aftereffect (deg)')
ylim([0,22])
title('Figure 1Q')