function [] = figure1CDEFG()

% load the data
dd = load('dataCDEFG.mat');
iNSm = dd.iNSm; iNSs = dd.iNSs;
iSm = dd.iSm; iSs = dd.iSs;
eNSm = dd.eNSm; eNSs = dd.eNSs;
eSm = dd.eSm; eSs = dd.eSs;
y20NSm = dd.y20NSm; y20NSs = dd.y20NSs;
y40NSm = dd.y40NSm; y40NSs = dd.y40NSs;
y60NSm = dd.y60NSm; y60NSs = dd.y60NSs;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% plot the behavior %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure
subplot(1,5,1)
hold on
plot(y20NSm,'-k')
plot(y20NSm-y20NSs,'--k')
plot(y20NSm+y20NSs,'--k')
plot(y40NSm,'-b')
plot(y40NSm-y40NSs,'--b')
plot(y40NSm+y40NSs,'--b')
plot(y60NSm,'-r')
plot(y60NSm-y60NSs,'--r')
plot(y60NSm+y60NSs,'--r')
ax = gca;
ax.TickDir = 'out';
ax.YTick = 0 : 20 : 60;
ax.XTick = [1,10:10:40];
xlim([1,40])
ylabel('reach angle (deg)')

colors = {'k','b','r'};
for n = 1 : 3
    bar(34+2*(n-1),iNSm(n),2,'FaceColor',colors{n},'EdgeColor','k')
    plot([34+2*(n-1),34+2*(n-1)],[iNSm(n)-iNSs(n),iNSm(n)+iNSs(n)],'-k')
end
title('Figure 1C')

% plot Figure 1D
subplot(1,5,2)
hold on
rs = [20,40,60];
for n = 1 : 3
    bar(rs(n),iNSm(n),10,'FaceColor',colors{n},'EdgeColor','k')
    plot([rs(n),rs(n)],[iNSm(n)-iNSs(n),iNSm(n)+iNSs(n)],'-k')
end
ax = gca;
ax.TickDir = 'out';
ylabel('implicit adaptation (deg)')
xlabel('rotation (deg)')
title('Figure 1D')

% plot Figure 1E
subplot(1,5,3)
hold on
rs = [20,40,60];
colors = {'k','b','r'};
for n = 1 : 3
    bar(rs(n),eNSm(n),10,'FaceColor',colors{n},'EdgeColor','k')
    plot([rs(n),rs(n)],[eNSm(n)-eNSs(n),eNSm(n)+eNSs(n)],'-k')
end
ax = gca;
ax.TickDir = 'out';
ylabel('explicit adaptation (deg)')
xlabel('rotation (deg)')
title('Figure 1E')

% plot Figure 1F
subplot(1,5,4)
hold on
RR = [20,40,60];
for n = 1 : 3
    bar(RR(n),RR(n)-eNSm(n),10,'FaceColor',colors{n},'EdgeColor','k')
    plot([RR(n),RR(n)],[RR(n)-eNSm(n)-eNSs(n),RR(n)-eNSm(n)+eNSs(n)],'-k')
end
ax = gca;
ax.TickDir = 'out';
ylabel('driving force (deg)')
xlabel('rotation (deg)')
title('Figure 1F')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% fit models and plot results %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% convert to SD
iNSs = iNSs * sqrt(10);
iSs = iSs * sqrt(10);
eNSs = eNSs * sqrt(10);
eSs = eSs * sqrt(10);

% the retention factor
a = 0.9853^3; % 9 trials during the exclusion period

% predict asymptote
asymptote = @(a,b,r,e) b*(r-e)/(1-a+b);

% the cost function
costfun = @(a,b,r,e,i) sum((i - asymptote(a,b,r,e)).^2);

% iterate through each strap
Nstraps = 10000;
r = [20,20,40,40,60,60];
V = zeros(Nstraps,6);
for n = 1 : Nstraps
    % sample data
    i20NS = normrnd(iNSm(1),iNSs(1),10,1);
    i40NS = normrnd(iNSm(2),iNSs(2),10,1);
    i60NS = normrnd(iNSm(3),iNSs(3),10,1);
    i20S = normrnd(iSm(1),iSs(1),10,1);
    i40S = normrnd(iSm(2),iSs(2),10,1);
    i60S = normrnd(iSm(3),iSs(3),10,1);
    e20NS = normrnd(eNSm(1),eNSs(1),10,1);
    e40NS = normrnd(eNSm(2),eNSs(2),10,1);
    e60NS = normrnd(eNSm(3),eNSs(3),10,1);
    e20S = normrnd(eSm(1),eSs(1),10,1);
    e40S = normrnd(eSm(2),eSs(2),10,1);
    e60S = normrnd(eSm(3),eSs(3),10,1);
    
    % calculate the mean
    i20NS = mean(i20NS);
    i40NS = mean(i40NS);
    i60NS = mean(i60NS);
    i20S = mean(i20S);
    i40S = mean(i40S);
    i60S = mean(i60S);
    e20NS = mean(e20NS);
    e40NS = mean(e40NS);
    e60NS = mean(e60NS);
    e20S = mean(e20S);
    e40S = mean(e40S);
    e60S = mean(e60S);   
    
    % wrap up for fit
    e = [e20NS,e20S,e40NS,e40S,e60NS,e60S];
    i = [i20NS,i20S,i40NS,i40S,i60NS,i60S];
    
    % get the optimal b
    b = fminbnd(@(b)costfun(a,b,r,e,i),0,1);
    
    % get the model prediction
    im = asymptote(a,b,r,e);
    V(n,:) = im;
end

% plot the result
subplot(1,5,5)
hold on
m = mean(V);
s = std(V);
for n = 1 : 3
    % data
    bar(n,iNSm(n),'FaceColor','k','EdgeColor','k')
    plot([n,n],[iNSm(n)-iNSs(n)/sqrt(10),iNSm(n)+iNSs(n)/sqrt(10)],'-k')
    
    % odd have the no strategy predictions
    ii = 2*n-1;
    bar(n+5,m(ii),'FaceColor','b','EdgeColor','k')
    plot([n+5,n+5],[m(ii)-s(ii),m(ii)+s(ii)],'-k')
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%% SPE independence model %%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% the retention factor
a = 0.9853^3; % 9 trials during the exclusion period

% predict asymptote
asymptote = @(a,b,r,e) b*r/(1-a+b);

% the cost function
costfun = @(a,b,r,e,i) sum((i - asymptote(a,b,r,e)).^2);

% iterate through each strap
Nstraps = 10000;
r = [20,20,40,40,60,60];
V = zeros(Nstraps,6);
for n = 1 : Nstraps
    % sample data
    i20NS = normrnd(iNSm(1),iNSs(1),10,1);
    i40NS = normrnd(iNSm(2),iNSs(2),10,1);
    i60NS = normrnd(iNSm(3),iNSs(3),10,1);
    i20S = normrnd(iSm(1),iSs(1),10,1);
    i40S = normrnd(iSm(2),iSs(2),10,1);
    i60S = normrnd(iSm(3),iSs(3),10,1);
    e20NS = normrnd(eNSm(1),eNSs(1),10,1);
    e40NS = normrnd(eNSm(2),eNSs(2),10,1);
    e60NS = normrnd(eNSm(3),eNSs(3),10,1);
    e20S = normrnd(eSm(1),eSs(1),10,1);
    e40S = normrnd(eSm(2),eSs(2),10,1);
    e60S = normrnd(eSm(3),eSs(3),10,1);
    
    % calculate the mean
    i20NS = mean(i20NS);
    i40NS = mean(i40NS);
    i60NS = mean(i60NS);
    i20S = mean(i20S);
    i40S = mean(i40S);
    i60S = mean(i60S);
    e20NS = mean(e20NS);
    e40NS = mean(e40NS);
    e60NS = mean(e60NS);
    e20S = mean(e20S);
    e40S = mean(e40S);
    e60S = mean(e60S);   
    
    % wrap up for fit
    e = [e20NS,e20S,e40NS,e40S,e60NS,e60S];
    i = [i20NS,i20S,i40NS,i40S,i60NS,i60S];
    
    % get the optimal b
    b = fminbnd(@(b)costfun(a,b,r,e,i),0,1);
    
    % get the model prediction
    im = asymptote(a,b,r,e);
    V(n,:) = im;
end

% plot the result
m = mean(V);
s = std(V);
for n = 1 : 3
    ii = 2*n-1;
    bar(n+10,m(ii),'FaceColor','g','EdgeColor','k')
    plot([n+10,n+10],[m(ii)-s(ii),m(ii)+s(ii)],'-k')
end
ax = gca;
ax.TickDir = 'out';
title('Figure 1G')
ylabel('implicit aftereffect (deg)')