function [] = figure10()

% load the data
load('data.mat','y1','yS1','y2','yS2');

% plot the data
figure
subplot(3,3,1)
hold on
plot(1:89,y1(1:89),'-b');
plot(1:89,y1(1:89)-yS1(1:89),'--b');
plot(1:89,y1(1:89)+yS1(1:89),'--b');
plot(97:169,y1(90:162),'-b');
plot(97:169,y1(90:162)-yS1(90:162),'--b');
plot(97:169,y1(90:162)+yS1(90:162),'--b');
plot(1:169,y2,'-r');
plot(1:169,y2-yS2,'--r');
plot(1:169,y2+yS2,'--r');
xlim([1,169])
ylabel('error w.r.t. primary target (deg)')
xlabel('movement number')
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,40:40:160];
ax.YTick = -20 : 20 : 40;
title('Figure 10A')

subplot(3,3,2)
hold on
plot((16:89)-15,y1(16:89),'-b');
plot((16:89)-15,(y1(16:89)-yS1(16:89)),'--b');
plot((16:89)-15,(y1(16:89)+yS1(16:89)),'--b');
plot((16:17)-15,y2(16:17),'-r');
plot((16:17)-15,(y2(16:17)-yS2(16:17)),'--r');
plot((16:17)-15,(y2(16:17)+yS2(16:17)),'--r');
plot((18:89)-15,y2(18:89)+45,'-r');
plot((18:89)-15,y2(18:89)-yS2(18:89)+45,'--r');
plot((18:89)-15,y2(18:89)+yS2(18:89)+45,'--r');
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,20:20:60];
ax.YTick = 0 : 10 : 50;
xlabel('movement number')
title('Figure 10B')

subplot(3,3,3)
hold on
plot((97:169)-95,y1(90:162),'-b');
plot((97:169)-95,(y1(90:162)-yS1(90:162)),'--b');
plot((97:169)-95,(y1(90:162)+yS1(90:162)),'--b');
plot((97:169)-95,y2(97:169),'-r');
plot((97:169)-95,(y2(97:169)-yS2(97:169)),'--r');
plot((97:169)-95,(y2(97:169)+yS2(97:169)),'--r');
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,20:20:60];
ax.YTick = -30 : 10 : 0;
xlabel('movement number')
title('Figure 10C')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% models %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% fit the data
lb = [0;0];
ub = [1;1];

% fit dual-error model
pars = fmincon(@(x)costfun(x,y1,y2,'both'),[0.995,0.02],[],[],[],[],lb,ub);

% simulate behavior with dual error model
[e,e2] = stateSpaceBoth(pars);

subplot(3,3,6)
hold on
% recast the first 2 trials of rotaiton in e2
e2(16) = e2(16) - 45;
e2(17) = e2(17) - 45;
% plot first 89 trials
plot(e(16:89),'b','LineWidth',1)
plot(e2(16:89)+45,'r','LineWidth',1)
ax = gca;
ax.TickDir = 'out';
xlim([1,74])
ax.YTick = 0 : 10 : 50;
ylabel('error w.r.t. aimed target (deg)')
xlabel('movement number')
title('Figure 10F')

% overlay in Figure 10B
subplot(3,3,2)
plot(e(16:89),'-k','LineWidth',1)
plot(e2(16:89)+45,'--k','LineWidth',1)

% plot each error source in Figure 10G
subplot(3,3,7)
hold on
[e1,e2] = stateSpaceBothErrors(pars);
hold on
e1 = e1(16:90);
e2 = e2(16:90);
plot(e1,'m')
plot(e2,'b')
xlim([1,75])
ax = gca;
ax.TickDir = 'out';
ylabel('error w.r.t. primary target (deg)')
xlabel('movement number')
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,20:20:60];
ax.YTick = -20:20:40;
title('Figure 10G')

% fit separate model
pars = fmincon(@(x)costfun(x,y1,y2,'1'),[0.995,0.02],[],[],[],[],lb,ub);

% simulate behavior with dual error model
[e,e2] = stateSpace1(pars);

subplot(3,3,5)
hold on
% recast the first 2 trials of rotaiton in e2
e2(16) = e2(16) - 45;
e2(17) = e2(17) - 45;
% plot first 89 trials
plot(e(16:89),'b','LineWidth',1)
plot(e2(16:89)+45,'--r','LineWidth',1)
ax = gca;
ax.TickDir = 'out';
xlim([1,74])
ax.YTick = 0 : 10 : 50;
ylabel('error w.r.t. aimed target (deg)')
xlabel('movement number')
title('Figure 10E')

% fit common model
pars = fmincon(@(x)costfun(x,y1,y2,'2'),[0.995,0.02],[],[],[],[],lb,ub);

% simulate behavior with dual error model
[e,e2] = stateSpace2(pars);

subplot(3,3,4)
hold on
% recast the first 2 trials of rotaiton in e2
e2(16) = e2(16) - 45;
e2(17) = e2(17) - 45;
% plot first 89 trials
plot(e(16:89),'b','LineWidth',1)
plot(e2(16:89)+45,'r','LineWidth',1)
ax = gca;
ax.TickDir = 'out';
xlim([1,74])
ax.YTick = 0 : 10 : 50;
ylabel('error w.r.t. aimed target (deg)')
xlabel('movement number')
title('Figure 10D')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%% plot Taylor and Ivry data %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% load the taylor-ivry data
load('taylor-ivry.mat','xYB','xBB','yYB','yBB','xYA','yYA','xBA','yBA',...
    'xYAU','yYAU','xYAL','yYAL','xBAU','yBAU','xBAL','yBAL','xBBU','yBBU',...
    'xBBL','yBBL','xYBU','yYBU','xYBL','yYBL','xBW','yBW','xYW','yYW','xYWU',...
    'yYWU','xYWL','yYWL','xBWU','yBWU','xBWL','yBWL',...
    'xBinit','yBinit','xYinit','yYinit','xBfinal','yBfinal','xYfinal','yYfinal');

% plot the data
subplot(3,3,8)
hold on
plot(xYB,yYB,'-','Color',[218 165 32]/255)
plot(xBB,yBB,'-k')
plot(xYA,yYA,'-','Color',[218 165 32]/255)
plot(xYW,yYW,'-','Color',[218 165 32]/255)
plot(xYAU,yYAU,'--','Color',[218 165 32]/255)
plot(xYAL,yYAL,'--','Color',[218 165 32]/255)
plot(xYBU,yYBU,'--','Color',[218 165 32]/255)
plot(xYBL,yYBL,'--','Color',[218 165 32]/255)
plot(xYWU,yYWU,'--','Color',[218 165 32]/255)
plot(xYWL,yYWL,'--','Color',[218 165 32]/255)
plot(xBA,yBA,'-k')
plot(xBW,yBW,'-k')
plot(xBAU,yBAU,'--k')
plot(xBAL,yBAL,'--k')
plot(xBBU,yBBU,'--k')
plot(xBBL,yBBL,'--k')
plot(xBWU,yBWU,'--k')
plot(xBWL,yBWL,'--k')
plot(xBinit,yBinit,'.k')
plot(xYinit,yYinit,'.','Color',[218 165 32]/255)
plot(xBfinal,yBfinal,'.k')
plot(xYfinal,yYfinal,'.','Color',[218 165 32]/255)
xlabel('movement number')
ylabel('error w.r.t. primary target (deg)')
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,80,160,240,323,400];
ax.YTick = -15 : 15 : 45;
title('Figure 10I')

% plot the aftereffects
% load the aftereffect data
load('aftereffect','aftereffect');
m1 = aftereffect(1,2);
s1 = aftereffect(2,2);
m2 = aftereffect(3,2);
s2 = aftereffect(4,2);

% the SEM
s1 = m1 - s1;
s2 = m2 - s2;

% plot the data
subplot(3,3,9)
hold on
bar(2,m1,'FaceColor',[218 165 32]/255,'EdgeColor','k')
plot([2,2],[m1-s1,m1+s1],'-k')
bar(1,m2,'FaceColor','k','EdgeColor','k')
plot([1,1],[m2-s2,m2+s2],'-k')
ax = gca;
ax.TickDir = 'out';
ax.YTick = 0 : 5 : 25;
ylabel('aftereffect (deg)')

end