function [e1,e2] = stateSpaceBothErrors(pars)
% here implicit system has two separate

% phase 1, no rotation, T aim to 0, 15 cycles (1 to 15)
% phase 2, rotation = -45, T aim to 0, 2 cycles (16 and 17)
% phase 3, rotation = -45, T aim to 45, 73 cycles (18 to 90)
% phase 4, rotation = -45, T aim to 0, 6 cycles (91 to 96)
% phase 5, no rotation, T aim to 0, 73 cycles (97 to 169)

T = [zeros(15,1) ; zeros(2,1) ; 45*ones(73,1) ; zeros(6,1) ; zeros(73,1)];
r = [zeros(15,1) ; -45*ones(2,1) ; -45*ones(73,1) ; -45*ones(6,1) ; zeros(73,1)];
a = pars(1);
b = pars(2);

e1 = zeros(size(r));
e2 = zeros(size(r));
x1 = zeros(size(r));
x2 = zeros(size(r));
x = zeros(size(r));

% the first trial
x(1) = T(1) + x1(1) + x2(1);
e1(1) = T(1) - (x(1) + r(1));
e2(1) = -(x(1) + r(1));

% iterate through each trial
for n = 2 : length(r)
    x1(n) = a*x1(n-1) + b*e1(n-1);
    x2(n) = a*x2(n-1) + b*e2(n-1);
    x(n) = T(n) + x1(n) + x2(n);
    if n == 16 || n == 17
        e1(n) = 0;
        e2(n) = -(x(n) + r(n));
    else
        e1(n) = T(n) - (x(n) + r(n));
        e2(n) = -(x(n) + r(n));
    end
end

% a normal rotation adaptation
r = [zeros(15,1) ; -45*ones(74,1) ; zeros(73,1)];
x = zeros(size(r));
e = zeros(size(r));
% the first trial
e(1) = -(x(1) + r(1));
% iterate through each trial
for n = 2 : length(r)
    x(n) = a*x(n-1) + b*e(n-1);
    e(n) = -(x(n) + r(n));
end

end