function [] = figure2_supplement1()

% load the data
dd = load('data.mat');
iNSm = dd.iNSm; iNSs = dd.iNSs;
iSm = dd.iSm; iSs = dd.iSs;
eNSm = dd.eNSm; eNSs = dd.eNSs;
eSm = dd.eSm; eSs = dd.eSs;

% the driving force
dNSm = [20,40,60] - eNSm;
dSm = [20,40,60] - eSm;

% plot implicit data all groups
figure
subplot(1,4,1)
hold on
for n = 1 : 3
    idx = 4*(n-1);
    bar(idx,iNSm(n),1,'FaceColor','k','EdgeColor','k')
    plot([idx,idx],[iNSm(n)-iNSs(n),iNSm(n)+iNSs(n)],'-k')
end
for n = 1 : 3
    idx = 4*(n-1)+1;
    bar(idx,iSm(n),1,'FaceColor','m','EdgeColor','k')
    plot([idx,idx],[iSm(n)-iNSs(n),iSm(n)+iSs(n)],'-k')
end
ax = gca;
ax.TickDir = 'out';
ylabel('implicit aftereffect (deg)')
title('Fig. 2-S1A')
ylim([0,14])

% plot driving force
subplot(1,4,4)
hold on
for n = 1 : 3
    idx = 4*(n-1);
    bar(idx,dNSm(n),1,'FaceColor','k','EdgeColor','k')
    plot([idx,idx],[dNSm(n)-eNSs(n),dNSm(n)+eNSs(n)],'-k')
end
for n = 1 : 3
    idx = 4*(n-1)+1;
    bar(idx,dSm(n),1,'FaceColor','m','EdgeColor','k')
    plot([idx,idx],[dSm(n)-eNSs(n),dSm(n)+eSs(n)],'-k')
end
ax = gca;
ax.TickDir = 'out';
ylabel('perturbation - explicit')
title('Fig. 2-S1D')
ylim([0,20])

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% fit models and plot results %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% convert to SD
iNSs = iNSs * sqrt(10);
iSs = iSs * sqrt(10);
eNSs = eNSs * sqrt(10);
eSs = eSs * sqrt(10);

% the retention factor
a = 0.9853^3; % 9 trials during the exclusion period

% predict asymptote
asymptote = @(a,b,r,e) b*(r-e)/(1-a+b);

% the cost function
costfun = @(a,b,r,e,i) sum((i - asymptote(a,b,r,e)).^2);

% iterate through each strap
Nstraps = 10000;
r = [20,20,40,40,60,60];
V = zeros(Nstraps,6);
for n = 1 : Nstraps
    % sample data
    i20NS = normrnd(iNSm(1),iNSs(1),10,1);
    i40NS = normrnd(iNSm(2),iNSs(2),10,1);
    i60NS = normrnd(iNSm(3),iNSs(3),10,1);
    i20S = normrnd(iSm(1),iSs(1),10,1);
    i40S = normrnd(iSm(2),iSs(2),10,1);
    i60S = normrnd(iSm(3),iSs(3),10,1);
    e20NS = normrnd(eNSm(1),eNSs(1),10,1);
    e40NS = normrnd(eNSm(2),eNSs(2),10,1);
    e60NS = normrnd(eNSm(3),eNSs(3),10,1);
    e20S = normrnd(eSm(1),eSs(1),10,1);
    e40S = normrnd(eSm(2),eSs(2),10,1);
    e60S = normrnd(eSm(3),eSs(3),10,1);
    
    % calculate the mean
    i20NS = mean(i20NS);
    i40NS = mean(i40NS);
    i60NS = mean(i60NS);
    i20S = mean(i20S);
    i40S = mean(i40S);
    i60S = mean(i60S);
    e20NS = mean(e20NS);
    e40NS = mean(e40NS);
    e60NS = mean(e60NS);
    e20S = mean(e20S);
    e40S = mean(e40S);
    e60S = mean(e60S);   
    
    % wrap up for fit
    e = [e20NS,e20S,e40NS,e40S,e60NS,e60S];
    i = [i20NS,i20S,i40NS,i40S,i60NS,i60S];
    
    % get the optimal b
    b = fminbnd(@(b)costfun(a,b,r,e,i),0,1);
    
    % get the model prediction
    im = asymptote(a,b,r,e);
    V(n,:) = im;
end

% plot the result
subplot(1,4,3)
hold on
m = mean(V);
s = std(V);
for n = 1 : 3
    idx = 4*(n-1);
    bar(idx,m(2*n-1),1,'FaceColor','k','EdgeColor','k')
    plot([idx,idx],[m(2*n-1)-s(2*n-1),m(2*n-1)+s(2*n-1)],'-k')
end
for n = 1 : 3
    idx = 4*(n-1)+1;
    bar(idx,m(2*n),1,'FaceColor','m','EdgeColor','k')
    plot([idx,idx],[m(2*n)-s(2*n),m(2*n)+s(2*n)],'-k')
end
ax = gca;
ax.TickDir = 'out';
ylabel('implicit aftereffect (deg)')
title('Fig. 2-S1C')
ylim([0,14])

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%% SPE independence model %%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% the retention factor
a = 0.9853^3; % 9 trials during the exclusion period

% predict asymptote
asymptote = @(a,b,r,e) b*r/(1-a+b);

% the cost function
costfun = @(a,b,r,e,i) sum((i - asymptote(a,b,r,e)).^2);

% iterate through each strap
Nstraps = 10000;
r = [20,20,40,40,60,60];
V = zeros(Nstraps,6);
for n = 1 : Nstraps
    % sample data
    i20NS = normrnd(iNSm(1),iNSs(1),10,1);
    i40NS = normrnd(iNSm(2),iNSs(2),10,1);
    i60NS = normrnd(iNSm(3),iNSs(3),10,1);
    i20S = normrnd(iSm(1),iSs(1),10,1);
    i40S = normrnd(iSm(2),iSs(2),10,1);
    i60S = normrnd(iSm(3),iSs(3),10,1);
    e20NS = normrnd(eNSm(1),eNSs(1),10,1);
    e40NS = normrnd(eNSm(2),eNSs(2),10,1);
    e60NS = normrnd(eNSm(3),eNSs(3),10,1);
    e20S = normrnd(eSm(1),eSs(1),10,1);
    e40S = normrnd(eSm(2),eSs(2),10,1);
    e60S = normrnd(eSm(3),eSs(3),10,1);
    
    % calculate the mean
    i20NS = mean(i20NS);
    i40NS = mean(i40NS);
    i60NS = mean(i60NS);
    i20S = mean(i20S);
    i40S = mean(i40S);
    i60S = mean(i60S);
    e20NS = mean(e20NS);
    e40NS = mean(e40NS);
    e60NS = mean(e60NS);
    e20S = mean(e20S);
    e40S = mean(e40S);
    e60S = mean(e60S);   
    
    % wrap up for fit
    e = [e20NS,e20S,e40NS,e40S,e60NS,e60S];
    i = [i20NS,i20S,i40NS,i40S,i60NS,i60S];
    
    % get the optimal b
    b = fminbnd(@(b)costfun(a,b,r,e,i),0,1);
    
    % get the model prediction
    im = asymptote(a,b,r,e);
    V(n,:) = im;
end

% plot the result
subplot(1,4,2)
hold on
m = mean(V);
s = std(V);
for n = 1 : 3
    idx = 4*(n-1);
    bar(idx,m(2*n-1),1,'FaceColor','k','EdgeColor','k')
    plot([idx,idx],[m(2*n-1)-s(2*n-1),m(2*n-1)+s(2*n-1)],'-k')
end
for n = 1 : 3
    idx = 4*(n-1)+1;
    bar(idx,m(2*n),1,'FaceColor','m','EdgeColor','k')
    plot([idx,idx],[m(2*n)-s(2*n),m(2*n)+s(2*n)],'-k')
end
ax = gca;
ax.TickDir = 'out';
ylabel('implicit aftereffect (deg)')
title('Fig. 2-S1B')
ylim([0,14])
