function [] = figure2EFG()

% load the data
dd = load('dataEFG.mat');
meanA = dd.meanA;
meanS = dd.meanS;
anglesA = dd.anglesA;
anglesS = dd.anglesS;
totalA = dd.totalA;
totalS = dd.totalS;

% determine explicit angles
iA = meanA;
iS = meanS;
tA = totalA;
tS = totalS;
eA = tA - iA;
eS = tS - iS;

% get the iA in each block
iAblock = iA;
iSblock = iS;

% average across all blocks in abrupt condition
iA = mean(iA);
eA = mean(eA);

% the rotations
rA = 60*ones(size(iA));
rS = repmat([15;30;45;60],1,size(iS,2));

% the driving force
dA = rA - eA;
dS = rS - eS;

% plot explicit
figure
subplot(1,3,2)
hold on

ii = eS(4,:);
m = nanmean(ii); %#ok<*NANMEAN>
s = nanstd(ii) / sqrt(length(ii)); %#ok<*NANSTD>
bar(2,m,'FaceColor','r','EdgeColor','k')
plot([2,2],[m-s,m+s],'Color','k')
plot(2*ones(size(ii))+0.2,ii,'.k')

m = nanmean(eA);
s = nanstd(eA) / sqrt(length(eA));
bar(1,m,'FaceColor',[139,69,19]/255,'EdgeColor','k')
plot([1,1],[m-s,m+s],'Color','k')
plot(1*ones(size(eA))-0.2,eA,'.k')

ylabel('explicit adaptation (deg)')
title('Figure 2F')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%% competition model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% get the scaling factor (b/1-a+b)
fun = @(x,y,p) sum((x - p*y).^2);

Nstraps = 1000;
iCompA = zeros(Nstraps,1);
iCompS = zeros(4,Nstraps);
ps = zeros(Nstraps,1);
for n = 1 : Nstraps
    % randomly samples participants
    idxA = randsample(length(dA),length(dA),1);
    iiA = nanmean(iA(idxA),2);
    ddA = nanmean(dA(idxA),2);
    idxS = randsample(size(dS,2),size(dS,2),1);
    iiS = nanmean(iS(:,idxS),2);
    ddS = nanmean(dS(:,idxS),2);
    
    % fit the competition model
    i = [iiA ; iiS];
    d = [ddA ; ddS];
    p = fminbnd(@(p)fun(i,d,p),0,1);
    iCompA(n) = ddA * p;
    iCompS(:,n) = ddS * p;
    ps(n) = p;
end

subplot(1,5,5)
hold on
for b = 1 : 4
    ii = iCompS(b,:);
    m = nanmean(ii);
    s = nanstd(ii);
    bar(b,m,'FaceColor','b','EdgeColor','k')
    plot([b,b],[m-s,m+s],'Color','k')
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%% independence model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% get the scaling factor (b/1-a+b)
fun = @(x,y,p) sum((x - p*y).^2);

Nstraps = 1000;
iIndepA = zeros(Nstraps,1);
iIndepS = zeros(4,Nstraps);
for n = 1 : Nstraps
    % randomly samples participants
    idxA = randsample(length(dA),length(dA),1);
    iiA = nanmean(iA(idxA),2);
    rrA = nanmean(rA(idxA),2);
    idxS = randsample(size(dS,2),size(dS,2),1);
    iiS = nanmean(iS(:,idxS),2);
    rrS = nanmean(rS(:,idxS),2);
    
    % fit the competition model
    i = [iiA ; iiS];
    r = [rrA ; rrS];
    p = fminbnd(@(p)fun(i,r,p),0,1);
    iIndepA(n) = rrA * p;
    iIndepS(:,n) = rrS * p;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%% display model results %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
subplot(1,3,3)
hold on

ii = iA;
m = nanmean(ii);
s = nanstd(ii) / sqrt(length(ii));
bar(0,m,'FaceColor',[139,69,19]/255,'EdgeColor','k')
plot([0,0],[m-s,m+s],'Color','k')

ii = iS(4,:);
m = nanmean(ii);
s = nanstd(ii) / sqrt(length(ii));
bar(1,m,'FaceColor','r','EdgeColor','k')
plot([1,1],[m-s,m+s],'Color','k')

ii = iIndepA;
m = nanmean(ii);
s = nanstd(ii);
bar(3,m,'FaceColor','g','EdgeColor','k')
plot([3,3],[m-s,m+s],'Color','k')

ii = iIndepS(4,:);
m = nanmean(ii);
s = nanstd(ii);
bar(4,m,'FaceColor','g','EdgeColor','k')
plot([4,4],[m-s,m+s],'Color','k')

ii = iCompA;
m = nanmean(ii);
s = nanstd(ii);
bar(6,m,'FaceColor','b','EdgeColor','k')
plot([6,6],[m-s,m+s],'Color','k')

ii = iCompS(4,:);
m = nanmean(ii);
s = nanstd(ii);
bar(7,m,'FaceColor','b','EdgeColor','k')
plot([7,7],[m-s,m+s],'Color','k')

title('Figure 2G')
ylabel('implicit adaptation (deg)')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% plot behavior and implicit %%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

subplot(1,3,1)
hold on
m = nanmean(anglesS,2);
s = nanstd(anglesS,[],2) / sqrt(size(anglesS,2));
plot(1:66,m(1:66),'-k')
plot(1:66,m(1:66)-s(1:66),'--k')
plot(1:66,m(1:66)+s(1:66),'--k')

plot(67:132,m(67:132),'-m')
plot(67:132,m(67:132)-s(67:132),'--m')
plot(67:132,m(67:132)+s(67:132),'--m')

plot(133:198,m(133:198),'-b')
plot(133:198,m(133:198)-s(133:198),'--b')
plot(133:198,m(133:198)+s(133:198),'--b')

plot(199:264,m(199:end),'-r')
plot(199:264,m(199:end)-s(199:end),'--r')
plot(199:264,m(199:end)+s(199:end),'--r')
plot(264*ones(size(iS(4,:)))+10*rand(size(iS(4,:))) + 10,iS(4,:),'.r')

% get the mean and SEM
m = mean(iSblock(4,:));
s = std(iSblock(4,:)) / sqrt(length(iSblock(4,:)));
bar(260,m,5,'FaceColor','r','EdgeColor','k')
plot([260,260],[m-s,m+s])

% abrupt group
m = nanmean(anglesA,2);
s = nanstd(anglesA,[],2) / sqrt(size(anglesA,2));
plot(1:264,m,'-','Color',[139,69,19]/255)
plot(1:264,m-s,'--','Color',[139,69,19]/255)
plot(1:264,m+s,'--','Color',[139,69,19]/255)
plot(264*ones(size(iAblock(4,:)))+10*rand(size(iAblock(4,:))) - 40,iAblock(4,:),'.','Color',[139,69,19]/255)

% get the mean and SEM
m = mean(iAblock(4,:));
s = std(iAblock(4,:)) / sqrt(length(iAblock(4,:)));
bar(248,m,5,'FaceColor',[139,69,19]/255,'EdgeColor','k')
plot([248,248],[m-s,m+s])

ax = gca;
ax.TickDir = 'out';
xlim([1,290])
ylabel('reach angle (deg)')
title('Figure 2E')