function [] = figure2_supplement3()

% load the data
dd = load('data.mat');
meanAbrupt = dd.meanAbrupt;
semAbrupt = dd.semAbrupt;
meanGradual = dd.meanGradual;
semGradual = dd.semGradual;

% determine Neville and Cressman extent of explicit learning
S1 = dd.sem1NoStrat60(:,2);
S2 = dd.sem2NoStrat60(:,2);

% get the mean across the lower and upper timepoints
M = (S1 + S2)/2;

% get the average across the 3 measurement periods in Neville/Cressman
M = mean(M);

% get the standard error
Sstrategy = mean(S1) - M;

mG = meanGradual;
mA = meanAbrupt;
sG = semGradual;
sA = semAbrupt;

% add another baseline trial to the mean gradual data (missed this during grabit)
mG = [mG(1,:) ; mG(2,:) ; mG(2,:) ; mG(3:end,:)];

% get only the y-coordinates
mG = mG(:,2);
sG = sG(:,2);
mA = mA(:,2);
sA = sA(:,2);

% reformat the standard errors
sG = sG - mG;
sA = mA - sA;

% construct the rotation
rA = [zeros(11,1) ; 60*ones(29,1) ; zeros(6,1)];
rG = [zeros(11,1) ; 10*ones(3,1) ; 20*ones(3,1) ; 30*ones(3,1) ; 40*ones(3,1) ; ...
    50*ones(3,1) ; 60*ones(14,1) ; zeros(6,1)];

% the perturation
figure
subplot(4,3,1)
hold on
plot(rA,'k')
plot(rG,'r')
xlim([1,46])
ylim([-1,61])
ax = gca;
ax.TickDir = 'out';
ax.YTick = 0 : 15 : 60;
ax.XTick = [1,15:15:45];
ylabel('rotation (deg)')
title('Fig. 2-S3A')

% plot a figure
subplot(4,3,4)
hold on
plot(mA,'-k')
plot(mA-sA,'--k')
plot(mA+sA,'--k')
plot(mG,'-r')
plot(mG-sG,'--r')
plot(mG+sG,'--r')
ax = gca;
ax.TickDir = 'out';
xlim([1,46])
ylim([-50,60])
ax = gca;
ax.TickDir = 'out';
ax.YTick = -45 : 15 : 60;
ax.XTick = [1,15:15:45];
ylabel('directional error (deg)')
title('Fig. 2-S3C')
xlabel('cycle number')

% construct the explicit strategy
t = 0 : 28;
b = M-10; c = 2;
xEP = M-b*exp(-c*t);
xEA = [zeros(11,1) ; xEP' ; zeros(6,1)];
xEG = zeros(46,1);

% fit best fit target error model
lb = [0;0];
ub = [1;1];

% initial guess
pars0 = [0.98,0.1];

% turn off fmincon output
options = optimoptions('fmincon');
options.Display = 'off';

% iterate through a bunch of straps
N = 20000;
EAtarget = zeros(46,N);
EGtarget = zeros(46,N);
XIAtarget = zeros(46,N);
XIGtarget = zeros(46,N);
XEAtarget = zeros(46,N);
XEGtarget = zeros(46,N);
for n = 1 : N
    % simulate behavior
    errorG = normrnd(mG,sG);
    errorA = normrnd(mA,sA);
    
    % simulate explicit strategy
    strategyG = normrnd(xEG,Sstrategy*ones(46,1));
    strategyA = normrnd(xEA,Sstrategy*ones(46,1));
    
    % now given these data, we ask for the best model fit
    parsTarget = fmincon(@(pars)costfun(pars,rA,rG,strategyA,strategyG,errorA,errorG,1),pars0,[],[],...
        [],[],lb,ub,[],options);
    
    % simulate the result
    [xIA,xIG] = targetErrorModelNoise(parsTarget,rA,rG,strategyA,strategyG,Sstrategy/5);
    
    % model errors
    EAtarget(:,n) = rA - xIA - xEA;
    EGtarget(:,n) = rG - xIG - xEG;
    
    % store simulation information
    XIAtarget(:,n) = xIA;
    XIGtarget(:,n) = xIG;
    XEAtarget(:,n) = strategyA;
    XEGtarget(:,n) = strategyG;
end

% iterate through a bunch of straps
EAspe = zeros(46,N);
EGspe = zeros(46,N);
XIAspe = zeros(46,N);
XIGspe = zeros(46,N);
XEAspe = zeros(46,N);
XEGspe = zeros(46,N);
for n = 1 : N
    % simulate behavior
    errorG = normrnd(mG,sG);
    errorA = normrnd(mA,sA);
    
    % simulate explicit strategy
    strategyG = normrnd(xEG,Sstrategy*ones(46,1));
    strategyA = normrnd(xEA,Sstrategy*ones(46,1));
    
    % now given these data, we ask for the best model fit
    parsSPE = fmincon(@(pars)costfun(pars,rA,rG,strategyA,strategyG,errorA,errorG,2),pars0,[],[],...
        [],[],lb,ub,[],options);
    
    % simulate the result
    [xIA,xIG] = SPEModelNoise(parsSPE,rA,rG,strategyA,strategyG,Sstrategy/5);
    
    % model errors
    EAspe(:,n) = rA - xIA - xEA;
    EGspe(:,n) = rG - xIG - xEG;
    
    % store simulation information
    XIAspe(:,n) = xIA;
    XIGspe(:,n) = xIG;
    XEAspe(:,n) = strategyA;
    XEGspe(:,n) = strategyG;
end

subplot(4,3,6)
hold on
plot(mean(EAtarget,2),'-k');
plot(mean(EAtarget,2)-std(EAtarget,[],2),'--k');
plot(mean(EAtarget,2)+std(EAtarget,[],2),'--k');
plot(mean(EGtarget,2),'-r');
plot(mean(EGtarget,2)-std(EGtarget,[],2),'--r');
plot(mean(EGtarget,2)+std(EGtarget,[],2),'--r');
xlim([1,46])
ylim([-50,55])
ax = gca;
ax.TickDir = 'out';
ax.YTick = -45 : 15 : 60;
ax.XTick = [1,15:15:45];
title('Fig. 2-S3E')

subplot(4,3,12)
hold on
plot(mean(XIAtarget,2),'-k');
plot(mean(XIAtarget,2)-std(XIAtarget,[],2),'--k');
plot(mean(XIAtarget,2)+std(XIAtarget,[],2),'--k');
plot(mean(XIGtarget,2),'-r');
plot(mean(XIGtarget,2)-std(XIGtarget,[],2),'--r');
plot(mean(XIGtarget,2)+std(XIGtarget,[],2),'--r');
xlim([1,46])
ylim([-6,48])
ax = gca;
ax.TickDir = 'out';
ax.YTick = 0 : 15 : 45;
ax.XTick = [1,15:15:45];
xlabel('cycle number')

subplot(4,3,9)
hold on
plot(mean(XEAtarget,2),'-k');
plot(mean(XEAtarget,2)-std(XEAtarget,[],2),'--k');
plot(mean(XEAtarget,2)+std(XEAtarget,[],2),'--k');
plot(mean(XEGtarget,2),'-r');
plot(mean(XEGtarget,2)-std(XEGtarget,[],2),'--r');
plot(mean(XEGtarget,2)+std(XEGtarget,[],2),'--r');
xlim([1,46])
ylim([-10,45])
ax = gca;
ax.TickDir = 'out';
ax.YTick = 0 : 15 : 45;
ax.XTick = [1,15:15:45];

xs = [20.5418,30.2081,39.8756];
plot(xs,(S1+S2)/2,'.','Color',[212,175,55]/255)
for n = 1 : 3
    plot([xs(n),xs(n)],[S1(n),S2(n)],'-','Color',[212,175,55]/255)
end

% SPE Model Results
subplot(4,3,5)
hold on
plot(mean(EAspe,2),'-k');
plot(mean(EAspe,2)-std(EAspe,[],2),'--k');
plot(mean(EAspe,2)+std(EAspe,[],2),'--k');
plot(mean(EGspe,2),'-r');
plot(mean(EGspe,2)-std(EGspe,[],2),'--r');
plot(mean(EGspe,2)+std(EGspe,[],2),'--r');
xlim([1,46])
ylim([-50,55])
ax = gca;
ax.TickDir = 'out';
ax.YTick = -45 : 15 : 60;
ax.XTick = [1,15:15:45];
title('Fig. 2-S3D')
ylabel('directional error (deg)')

subplot(4,3,11)
hold on
plot(mean(XIAspe,2),'-k');
plot(mean(XIAspe,2)-std(XIAspe,[],2),'--k');
plot(mean(XIAspe,2)+std(XIAspe,[],2),'--k');
plot(mean(XIGspe,2),'-r');
plot(mean(XIGspe,2)-std(XIGspe,[],2),'--r');
plot(mean(XIGspe,2)+std(XIGspe,[],2),'--r');
xlim([1,46])
ylim([-6,48])
ax = gca;
ax.TickDir = 'out';
ax.YTick = 0 : 15 : 45;
ax.XTick = [1,15:15:45];
ylabel('implicit angle (deg)')
xlabel('cycle number')

subplot(4,3,8)
hold on
plot(mean(XEAspe,2),'-k');
plot(mean(XEAspe,2)-std(XEAspe,[],2),'--k');
plot(mean(XEAspe,2)+std(XEAspe,[],2),'--k');
plot(mean(XEGspe,2),'-r');
plot(mean(XEGspe,2)-std(XEGspe,[],2),'--r');
plot(mean(XEGspe,2)+std(XEGspe,[],2),'--r');
xlim([1,46])
ylim([-10,45])
ax = gca;
ax.TickDir = 'out';
ax.YTick = 0 : 15 : 45;
ax.XTick = [1,15:15:45];
ylabel('explicit aim (deg)')

xs = [20.5418,30.2081,39.8756];
plot(xs,(S1+S2)/2,'.','Color',[212,175,55]/255)
for n = 1 : 3
    plot([xs(n),xs(n)],[S1(n),S2(n)],'-','Color',[212,175,55]/255)
end

% now get the aftereffect
AEAtarget = EAtarget(41,:);
AEGtarget = EGtarget(41,:);
AEAspe = EAspe(41,:);
AEGspe = EGspe(41,:);

% plot results
subplot(4,3,7)
hold on
m = mA(41);
s = sA(41);
bar(1,m,'FaceColor','k','EdgeColor','k')
plot([1,1],[m-s,m+s],'-k')
m = mG(41);
s = sG(41);
bar(2,m,'FaceColor','r','EdgeColor','k')
plot([2,2],[m-s,m+s],'-k')


m = mean(AEAspe);
s = std(AEAspe);
bar(4,m,'FaceColor','g','EdgeColor','k')
plot([4,4],[m-s,m+s],'-k')
m = mean(AEGspe);
s = std(AEGspe);
bar(5,m,'FaceColor','g','EdgeColor','k')
plot([5,5],[m-s,m+s],'-k')

m = mean(AEAtarget);
s = std(AEAtarget);
bar(7,m,'FaceColor','b','EdgeColor','k')
plot([7,7],[m-s,m+s],'-k')
m = mean(AEGtarget);
s = std(AEGtarget);
bar(8,m,'FaceColor','b','EdgeColor','k')
plot([8,8],[m-s,m+s],'-k')
ax = gca;
ax.TickDir = 'out';
ax.YTick = -45 : 15 : 0;
ylabel('aftereffect (deg)')
title('Fig. 2-S3F')

