function [xIA,xIG] = targetErrorModel(pars,rA,rG,xEA,xEG)

% get input parameters
a = pars(1);
b = pars(2);

% now simulate gradual and abrupt learning
xIG = zeros(46,1);
xIA = zeros(46,1);
eG = zeros(46,1);
eA = zeros(46,1);

% calculate the first error
eA(1) = rA(1) - xIA(1) - xEA(1);
eG(1) = rG(1) - xIG(1) - xEG(1);

% iterate through other trials
for n = 2 : 46
    % learn from error
    xIA(n) = a*xIA(n-1) + b*eA(n-1);
    xIG(n) = a*xIG(n-1) + b*eG(n-1);
    
    % calculate the next error
    eA(n) = rA(n) - xIA(n) - xEA(n);
    eG(n) = rG(n) - xIG(n) - xEG(n);
end

 