function [] = figure3()

% load the data
dd = load('data-experiment-2-no-PT-limit.mat');
I = dd.I;
E = dd.E;
A = dd.A;
RT = dd.RT;
nSubjects = length(I);

% plot the rotation
figure
subplot(6,3,1)
plot([zeros(10,1);30*ones(60,1)],'-k')
ylim([-2,32])
ax = gca;
ax.TickDir = 'out';
ylabel('pert. (deg)')
title('Figure 3A')

% plot the behavior
subplot(6,3,4)
hold on
m = nanmean(A(1:end-1,:),2);
s = nanstd(A(1:end-1,:),[],2) / sqrt(nSubjects);
plot(m,'-k')
plot(m-s,'--k')
plot(m+s,'--k')
m = nanmean(A(end,:));
s = nanstd(A(end,:)) / sqrt(nSubjects);
plot(71,m,'.k')
plot([71,71],[m-s,m+s],'-k')
ax = gca;
ax.TickDir = 'out';
ylabel('reach angle (deg)')
title('Figure 3B');
ylim([-6,31])

% plot the reaction time
subplot(6,3,7)
hold on
m = nanmean(RT(1:end-1,:),2);
s = nanstd(RT(1:end-1,:),[],2) / sqrt(nSubjects);
plot(m,'-k')
plot(m-s,'--k')
plot(m+s,'--k')
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,20:20:60];
ax.YTick = 0.2 : 0.1 : 0.6;
xlim([1,70])
ylim([0.15,0.62])
ylabel('preparation time (sec)')
xlabel('cycle number (trials 4x)')
title('Figure 3C')

subplot(6,3,3)
hold on
plot(E,I,'.k')
p = polyfit(E,I,1);
Ipred = polyval(p,E);
plot(E,Ipred,'-k')
% the error sensitivity and retention factor PT Limit
b = 0.35;
a = 0.943;
% competition model predictions
p = b/(1-a+b);
Ipred = p*(30 - E);
plot(E,Ipred,'-b')
ylabel('implicit angle (deg)')
xlabel('explicit angle (deg)')
title('Figure 3G')

% add explicit learning to Fig. 3N
subplot(6,3,6)
hold on
m = mean(E);
s = std(E) / sqrt(length(E));
bar(1,m,'FaceColor','k','EdgeColor','k')
plot([1,1],[m-s,m+s],'-k')
plot(ones(size(E)),E,'.','Color',[153,101,21]/255)
title('Figure 3N')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% E2 Limit PT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% load the data
dd = load('data-experiment-2-limit-PT.mat');
A = dd.A;
RT = dd.RT;
nSubjects = size(RT,2);

% plot the rotation
subplot(6,3,2)
plot([zeros(10,1);30*ones(60,1)],'-k')
ylim([-2,32])
ax = gca;
ax.TickDir = 'out';
ylabel('pert. (deg)')
title('Figure 3D')

% plot the reach angle
subplot(6,3,5)
hold on
m = nanmean(A,2);
s = nanstd(A,[],2) / sqrt(nSubjects);
plot(m,'-r')
plot(m-s,'--r')
plot(m+s,'--r')
xlim([1,85])
ax = gca;
ax.TickDir = 'out';
ylabel('reach angle (deg)')
ylim([-6,31])
title('Figure 3E')

% plot the reaction time
subplot(6,3,8)
hold on
m = nanmean(RT,2);
s = nanstd(RT,[],2) / sqrt(nSubjects);
plot(m,'-r')
plot(m-s,'--r')
plot(m+s,'--r')
xlim([1,85])
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,20:20:80];
ax.YTick = 0.2 : 0.1 : 0.6;
ylim([0.15,0.62])
xlabel('cycle number (trials 4x)')
ylabel('preparation time (sec)')
title('Figure 3F')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% E3, No PT Limit %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% load the data
dd = load('data-experiment-3-no-PT-limit.mat');
A = dd.A;
RT = dd.RT;
E = dd.E;
IEARLY = dd.IEARLY;
ILATE = dd.ILATE;

% the number of subjects
num_subjects = length(E);

% plot the rotation
subplot(6,3,10)
plot([zeros(10,1);30*ones(60,1)],'-k')
xlim([1,90])
title('Figure 3H')
ylabel('pert. (deg)')
title('Figure 3H')

% plot the behavior
subplot(6,3,13)
hold on
m = nanmean(A,2);
s = nanstd(A,[],2) / sqrt(num_subjects);
plot(1:70,m(1:70),'-k')
plot(1:70,m(1:70)-s(1:70),'--k')
plot(1:70,m(1:70)+s(1:70),'--k')
plot(71:90,m(71:90),'-k')
plot(71:90,m(71:90)-s(71:90),'--k')
plot(71:90,m(71:90)+s(71:90),'--k')
xlim([1,90])
ylim([-3,26])
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,15:15:90];
ax.YTick = 0 : 5 : 25;
ylabel('reach angle (deg)')
title('Figure 3I')

% plot the reaction time
subplot(6,3,16)
hold on
m = nanmean(RT,2);
s = nanstd(RT,[],2) / sqrt(num_subjects);
plot(1:70,m(1:70),'-k')
plot(1:70,m(1:70)-s(1:70),'--k')
plot(1:70,m(1:70)+s(1:70),'--k')
plot(71:90,m(71:90),'-k')
plot(71:90,m(71:90)-s(71:90),'--k')
plot(71:90,m(71:90)+s(71:90),'--k')
xlim([1,90])
ylim([0.1,0.55])
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,15:15:90];
ylabel('preparation time (sec)')
xlabel('cycle number (trials 4x)')
title('Figure 3J')

subplot(6,3,15)
hold on
plot(E,ILATE,'.k')
p = polyfit(E,ILATE,1);
yfit = polyval(p,E);
plot(E,yfit,'-k')
Rsquared = var(yfit)/var(ILATE);
ylabel('early corr')
xlabel(num2str(Rsquared))
ax = gca;
ax.TickDir = 'out';
ax.YTick = 4 : 4 : 20;
ax.XTick = 0 : 5 : 25;
ylabel('implicit angle (deg)')
xlabel('explicit angle (deg)')
title('Figure 3P')

subplot(6,3,18)
hold on
plot(E,IEARLY,'.k')
p = polyfit(E,IEARLY,1);
yfit = polyval(p,E);
plot(E,yfit,'-k')
Rsquared = var(yfit)/var(IEARLY);
ylabel('early corr')
xlabel(num2str(Rsquared))
ax = gca;
ax.TickDir = 'out';
ax.YTick = 4 : 4 : 20;
ax.XTick = 0 : 5 : 25;
ylabel('implicit angle (deg)')
xlabel('explicit angle (deg)')
title('Figure 3Q')

% competition model prediction
a = 0.8993;
b = 0.19336;
slope = -b/(1-a+b);
intercept = 30*b/(1-a+b);
p = [slope,intercept];
yfit = polyval(p,E);
plot(E,yfit,'-b')

% plot explicit learning
subplot(6,3,6)
hold on
E = dd.Eall;
m = mean(E);
s = std(E) / sqrt(length(E));
bar(2,m,'FaceColor','k','EdgeColor','k')
plot([2,2],[m-s,m+s],'-k')
plot(2*ones(size(E)),E,'.m')

% plot implicit learning
subplot(6,3,9)
hold on
I = dd.Iall;
m = mean(I);
s = std(I) / sqrt(length(I));
bar(1,m,'FaceColor','k','EdgeColor','k')
plot([1,2],[m-s,m+s],'-k')
plot(1*ones(size(I)),I,'.m')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% E3 Limit PT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% load the data
dd = load('data-experiment-3-limit-PT.mat');
A = dd.A;
I = dd.I;
E = dd.E;
RT = dd.RT;
num_subjects = length(E);

% plot the rotation
subplot(6,3,11)
plot([zeros(10,1);30*ones(60,1)],'-k')
xlim([1,90])
ylim([-2,32])
ylabel('pert. (deg)')
title('Figure 3K')
ax = gca;
ax.TickDir = 'out';

% the behavior
subplot(6,3,14)
hold on
m = nanmean(A,2);
s = nanstd(A,[],2) / sqrt(num_subjects);
plot(1:70,m(1:70),'-r')
plot(1:70,m(1:70)-s(1:70),'--r')
plot(1:70,m(1:70)+s(1:70),'--r')
plot(71:90,m(71:90),'-r')
plot(71:90,m(71:90)-s(71:90),'--r')
plot(71:90,m(71:90)+s(71:90),'--r')
xlim([1,90])
ylim([-3,26])
ax = gca;
ax.YTick = 0:5:25;
ax.TickDir = 'out';
ax.XTick = [1,15:15:90];
ylabel('reach angle (deg)')
title('Figure 3L')

% plot the reaction time
subplot(6,3,17)
hold on
m = nanmean(RT,2);
s = nanstd(RT,[],2) / sqrt(num_subjects);
plot(1:70,m(1:70),'-r')
plot(1:70,m(1:70)-s(1:70),'--r')
plot(1:70,m(1:70)+s(1:70),'--r')
plot(71:90,m(71:90),'-r')
plot(71:90,m(71:90)-s(71:90),'--r')
plot(71:90,m(71:90)+s(71:90),'--r')
xlim([1,90])
ylim([0.1,0.55])
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,15:15:90];
ylabel('preparation time (sec)')
xlabel('cycle number (trials 4x)')
title('Figure 3M')

% the explicit measure
subplot(6,3,6)
hold on
m = mean(E);
s = std(E) / sqrt(length(E));
bar(3,m,'FaceColor','r','EdgeColor','k')
plot([3,3],[m-s,m+s])
plot(3*ones(size(E)),E,'.b')

% the implicit measure
m = mean(I);
s = std(I) / sqrt(length(I));
subplot(6,3,9)
hold on
bar(2,m,'FaceColor','r','EdgeColor','k')
plot([2,2],[m-s,m+s])
plot(2*ones(size(I)),I,'.b')
ax = gca;
ax.TickDir = 'out';
ylim([0,26.5])
ylabel('implicit angle (deg)')
