function [] = figure3_supplement3()

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%% example Limit PT participant %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% load the data
dd = load('data-limit-PT.mat');
X = dd.X;
Y = dd.Y;

% plot the results
N = numel(X);
colors = jet(240);
figure
for n = 1 : N
    % gets the x-positions and y-positions
    x = X{n};
    y = Y{n};
    
    if n <= 40
        subplot(2,3,1)
        hold on
        plot(x,y,'-k')
    elseif n <= 280
        subplot(2,3,2)
        hold on
        plot(x,y,'Color',colors(n-40,:))
    else
        subplot(2,3,3)
        hold on
        plot(x,y,'c')
    end    
end
subplot(2,3,1)
xlim([-400,400])
ylim([-400,400])
xlabel('x-pixels')
ylabel('y-pixels')
title('baseline')
subplot(2,3,2)
xlim([-400,400])
ylim([-400,400])
xlabel('x-pixels')
ylabel('y-pixels')
title('rotation')
subplot(2,3,3)
xlim([-400,400])
ylim([-400,400])
xlabel('x-pixels')
ylabel('y-pixels')
title('no aiming')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%% example No PT Limit participant %%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% load the data
dd = load('data-no-PT-limit.mat');
X = dd.X;
Y = dd.Y;

% plot the results
N = numel(X);
colors = jet(240);
for n = 1 : N
    % gets the x-positions and y-positions
    x = X{n};
    y = Y{n};
    
    if n <= 40
        subplot(2,3,4)
        hold on
        plot(x,y,'-k')
    elseif n <= 280
        subplot(2,3,5)
        hold on
        plot(x,y,'Color',colors(n-40,:))
    else
        subplot(2,3,6)
        hold on
        plot(x,y,'c')
    end    
end
subplot(2,3,4)
xlim([-400,400])
ylim([-400,400])
xlabel('x-pixels')
ylabel('y-pixels')
title('baseline')
subplot(2,3,5)
xlim([-400,400])
ylim([-400,400])
xlabel('x-pixels')
ylabel('y-pixels')
title('rotation')
subplot(2,3,6)
xlim([-400,400])
ylim([-400,400])
xlabel('x-pixels')
ylabel('y-pixels')
title('no aiming')


end