function [output] = callAIC(meanS,totalS,mSlope,sSigma)

% determine explicit angles
iS = meanS;
tS = totalS;
eS = tS - iS;

% the rotations
rS = repmat([15;30;45;60],1,size(iS,2));

% the driving force
dS = rS - eS;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% competition model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% the competition model
fun = @(x,y,p) sum((x - p*y).^2);

% an array for the model error
LLcomp = zeros(37,1);

% iterate through each participant
for s = 1 : 37
    % get data for this participant
    iii = iS(:,s);
    ddd = dS(:,s);
    
    % fit model to participant data
    p = fminbnd(@(p)fun(iii,ddd,p),0,1);
    
    % get the prediction implicit learning
    iPred = p * ddd;
    
    % calculate the residuals
    RES = iPred - iii;
    
    % calculate the RMSE
    sigma = sqrt(mean(RES.^2));
    
    % the number of data points
    N = length(RES);
    
    % calculate the log-likelihood
    LLcomp(s) = -N*log(2*pi*sigma^2) - (1/(2*sigma^2)) * sum(RES.^2);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% single subject gen SPE %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% an array for the model error
LLLinMc = zeros(37,1);

% an array for the rotations
rrr = [15 ; 30 ; 45 ; 60];

% iterate through each participant
for s = 1 : 37
    % get data for this participant
    iii = iS(:,s);
    eee = eS(:,s);
    
    % fit model to participant data
    p = fit_lin(iii,eee,mSlope,rrr);
    
    % get the prediction implicit learning
    iPred = xILin(eee,p,rrr,mSlope);
    
    % calculate the residuals
    RES = iPred - iii;
    
    % calculate the RMSE
    sigma = sqrt(mean(RES.^2));
    
    % the number of data points
    N = length(RES);
    
    % calculate the log-likelihood
    LLLinMc(s) = -N*log(2*pi*sigma^2) - (1/(2*sigma^2)) * sum(RES.^2);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% McDougle normal %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% an array for the model error
LLNormMc = zeros(37,1);

% an array for the rotations
rrr = [15 ; 30 ; 45 ; 60];

% iterate through each participant
for s = 1 : 37
    % get data for this participant
    iii = iS(:,s);
    eee = eS(:,s);
    
    % fit model to participant data
    p = fit_gauss(iii,eee,sSigma,rrr);
    
    % get the prediction implicit learning
    iPred = xIGauss(eee,p,rrr,sSigma);
    
    % calculate the residuals
    RES = iPred - iii;
    
    % calculate the RMSE
    sigma = sqrt(mean(RES.^2));
    
    % the number of data points
    N = length(RES);
    
    % calculate the log-likelihood
    LLNormMc(s) = -N*log(2*pi*sigma^2) - (1/(2*sigma^2)) * sum(RES.^2);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%% only McDougle models %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% calculate the AIC
AICcomp = 2 - 2 * LLcomp;
AICLinMc = 2 - 2 * LLLinMc;
AICNormMc = 2 - 2 * LLNormMc;

% combine together
AIC = [AICcomp,AICLinMc,AICNormMc];

% results matrix
ranks = zeros(37,3);

% determine the minimum
for s = 1 : 37
    % get the data for this participant
    dd = AIC(s,:);
    
    % sort the data
    [~,idx] = sort(dd);
    
    % store in the ranks matrix
    ranks(s,:) = idx;
    
    % store the ranks
    for xx = 1 : length(idx)
        ranks(s,idx(xx)) = xx;
    end
end

% determine the best models
output = sum(ranks == 1);