function [] = figure4AB(fHandle)

% load Experiment 2 data
dd = load('data-experiment-2-no-PT-limit.mat');
I = dd.I;
E = dd.E;
% fit a line
p = polyfit(E,I,1);
% use y-intercept to normalize
I = I / p(2) * 100;

% plot the normalized data
figure(fHandle)
subplot(3,6,2)
hold on
plot(E,I,'.','Color',[166 123 91]/255)
% re-fit and plot line
p = polyfit(E,I,1);
Ipred = polyval(p,E);
plot(E,Ipred,'-','Color',[166 123 91]/255)

% load Experiment 3 data
dd = load('data-experiment-3-no-PT-limit.mat');
I = dd.IEARLY;
E = dd.E;
% fit a line
p = polyfit(E,I,1);
% use y-intercept to normalize
I = I / p(2) * 100;
plot(E,I,'.k')
% re-fit and plot line
p = polyfit(E,I,1);
Ipred = polyval(p,E);
plot(E,Ipred,'-k')
xlim([0,120])
ylim([-20,120])
ax = gca;
ax.TickDir = 'out';
ax.YTick = 0 : 20 : 120;
ax.XTick = 0 : 20 : 120;
ylabel('implicit angle (% total)')
xlabel('explicit angle (deg)')
title('Figure 4A')

% load literature generalization curves
d = load('data-literature.mat');
MCXm = d.MCXm1; MCYm = d.MCYm1; MCYs = d.MCYs1;
plot(MCXm,MCYm,'-','Color',[205,127,50]/255)
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color',[205,127,50]/255)
end

MCXm = d.MCXm2; MCYm = d.MCYm2; MCYs = d.MCYs2;
plot(MCXm,MCYm,'-','Color','m')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','m')
end

MCXm = d.MCXm3; MCYm = d.MCYm3; MCYs = d.MCYs3;
plot(MCXm,MCYm,'-','Color','b')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','b')
end

MCXm = d.MCXm4; MCYm = d.MCYm4; MCYs = d.MCYs4;
plot(MCXm,MCYm,'-','Color','g')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','g')
end

MCXm = d.MCXm5; MCYm = d.MCYm5; MCYs = d.MCYs5;
plot(MCXm,MCYm,'-','Color','r')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','r')
end

MCXm = d.MCXm6; MCYm = d.MCYm6; MCYs = d.MCYs6;
plot(MCXm,MCYm,'-','Color','c')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','c')
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%% Part B %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% load Experiment 2 data
dd = load('data-experiment-2-no-PT-limit.mat');
I = dd.I;
E = dd.E;

% plot the data
figure(fHandle)
subplot(3,6,3)
hold on
plot(E,I,'.k')
% re-fit and plot line
p = polyfit(E,I,1);
Ipred = polyval(p,[0,max(E)]);
plot([0,max(E)],Ipred,'-k')
title('Figure 4B')
ax = gca;
ax.TickDir = 'out';
ax.YTick = 8 : 4 : 24;
ax.XTick = 0 : 4 : 16;
ylabel('implicit angle (deg)')
xlabel('explicit angle (deg)')
xlim([0,20])
ylim([7,28])

% the competition model
% the error sensitivity and retention factor PT Limit
b = 0.35;
a = 0.943;
% competition model predictions
pp = b/(1-a+b);
Ipred = pp*(30 - [0,max(E)]);
plot([0,max(E)],Ipred,'-','Color',[166,123,35]/255)

% the slopes
slope = d.slope11;
intercept = p(2);
y1 = slope*[0,max(E)] + intercept;
plot([0,max(E)],y1,'-','Color',[205,127,50]/255)

slope = d.slope21;
intercept = p(2);
y1 = slope*[0,max(E)] + intercept;
plot([0,max(E)],y1,'-','Color','m')

slope = d.slope31;
intercept = p(2);
y1 = slope*[0,max(E)] + intercept;
plot([0,max(E)],y1,'-','Color','b')

slope = d.slope41;
intercept = p(2);
y1 = slope*[0,max(E)] + intercept;
plot([0,max(E)],y1,'-','Color','g')

slope = d.slope51;
intercept = p(2);
y1 = slope*[0,max(E)] + intercept;
plot([0,max(E)],y1,'-','Color','r')

slope = d.slope61;
intercept = p(2);
y1 = slope*[0,max(E)] + intercept;
plot([0,max(E)],y1,'-','Color','c')

% load Experiment 3 data
dd = load('data-experiment-3-no-PT-limit.mat');
I = dd.IEARLY;
E = dd.E;

figure(fHandle)
subplot(3,6,4)
hold on
plot(E,I,'.k')
% re-fit and plot line
p = polyfit(E,I,1);
Ipred = polyval(p,E);
plot(E,Ipred,'-k')
ax = gca;
ax.TickDir = 'out';
ax.YTick = 0 : 5 : 20;
ax.XTick = 0 : 5 : 25;
ylabel('implicit angle (deg)')
xlabel('explicit angle (deg)')
xlim([-3,30])
ylim([0,24])

% the competition model
a = 0.8993;
b = 0.19336;
slope = -b/(1-a+b);
intercept = 30*b/(1-a+b);
pp = [slope,intercept];
yfit = polyval(pp,[0,max(E)]);
plot([0,max(E)],yfit,'-','Color',[166,123,35]/255)

% the slopes
slope = d.slope12;
intercept = p(2);
y1 = slope*[0,max(E)] + intercept;
plot([0,max(E)],y1,'-','Color',[205,127,50]/255)

slope = d.slope22;
intercept = p(2);
y1 = slope*[0,max(E)] + intercept;
plot([0,max(E)],y1,'-','Color','m')

slope = d.slope32;
intercept = p(2);
y1 = slope*[0,max(E)] + intercept;
plot([0,max(E)],y1,'-','Color','b')

slope = d.slope42;
intercept = p(2);
y1 = slope*[0,max(E)] + intercept;
plot([0,max(E)],y1,'-','Color','g')

slope = d.slope52;
intercept = p(2);
y1 = slope*[0,max(E)] + intercept;
plot([0,max(E)],y1,'-','Color','r')

slope = d.slope62;
intercept = p(2);
y1 = slope*[0,max(E)] + intercept;
plot([0,max(E)],y1,'-','Color','c')
