function [] = figure5_supplement3()

figure
load('data-tsay.mat','e30','t30');
subplot(3,4,2)
hold on
plot(t30,e30,'.k')
ylabel('explicit angle (deg)')
xlabel('total adaptation (deg)')
p = polyfit(t30,e30,1);
y = polyval(p,t30);
plot(t30,y,'-','Color',[75 54 33]/255,'LineWidth',1)
title('FIgure 5-S3A')

% load and plot data
load('data-experiment-1.mat','eS','tS');
subplot(3,4,3)
hold on
plot(tS(2,:),eS(2,:),'.k')
ylabel('explicit angle (deg)')
xlabel('total adaptation (deg)')
p = polyfit(tS(2,:),eS(2,:),1);
y = polyval(p,tS(2,:));
plot(tS(2,:),y,'-','Color',[75 54 33]/255,'LineWidth',1)
title('FIgure 5-S3B')

% load and plot data
load('explicit-variability-analysis','outputTE','outputTI','sigmaExplicit')
subplot(3,4,7)
hold on
plot(sigmaExplicit,outputTI(:,1),'-r','LineWidth',1)
plot(sigmaExplicit,outputTE(:,3),'-g','LineWidth',1)
ylabel('probability')
xlabel('sub-sub var. in strat. (deg)')
ax = gca;
ax.TickDir = 'out';
xlim([sigmaExplicit(1),sigmaExplicit(end)])
title('Figure 5-S3E')

subplot(3,4,11)
hold on
plot(outputTE(:,5),outputTI(:,5),'.b')
plot([min(outputTE(:,5)),max(outputTE(:,5))],[min(outputTE(:,5)),max(outputTE(:,5))],'-k')
xlim([min(outputTE(:,5)),max(outputTE(:,5))])
ax = gca;
ax.TickDir = 'out';
xlabel('R^2 explicit-total')
ylabel('R^2 implicit-total')

% load and plot data
load('probe-trial-analysis','outputTE','outputTI','Nprobe')
subplot(3,4,5)
hold on
plot(Nprobe,outputTI(:,1),'-r','LineWidth',1)
plot(Nprobe,outputTE(:,3),'-g','LineWidth',1)
ylabel('probability')
xlabel('number aftereffect trials')
ax = gca;
ax.TickDir = 'out';
xlim([Nprobe(1),Nprobe(end)])
title('Figure 5-S3C')

subplot(3,4,9)
hold on
plot(outputTE(:,5),outputTI(:,5),'.b')
plot([min(outputTE(:,5)),max(outputTE(:,5))],[min(outputTE(:,5)),max(outputTE(:,5))],'-k')
xlim([min(outputTE(:,5)),max(outputTE(:,5))])
ax = gca;
ax.TickDir = 'out';
xlabel('R^2 explicit-total')
ylabel('R^2 implicit-total')

% load and plot data
load('total-explicit-analysis','meanExplicit','outputTE','outputTI')
subplot(3,4,8)
hold on
plot(meanExplicit,outputTI(:,1),'-r','LineWidth',1)
plot(meanExplicit,outputTE(:,3),'-g','LineWidth',1)
ylabel('probability')
xlabel('avg. strategy use (deg)')
ax = gca;
ax.TickDir = 'out';
xlim([meanExplicit(1),meanExplicit(end)])
title('Figure 5-S3F')

subplot(3,4,12)
hold on
plot(outputTE(:,5),outputTI(:,5),'.b')
plot([min(outputTE(:,5)),max(outputTE(:,5))],[min(outputTE(:,5)),max(outputTE(:,5))],'-k')
xlim([min(outputTE(:,5)),max(outputTE(:,5))])
ax = gca;
ax.TickDir = 'out';
xlabel('R^2 explicit-total')
ylabel('R^2 implicit-total')

% load and plot data
load('motor-variability-analysis','sigmaMotorMean','outputTE','outputTI')
subplot(3,4,6)
hold on
plot(sigmaMotorMean,outputTI(:,1),'-r','LineWidth',1)
plot(sigmaMotorMean,outputTE(:,3),'-g','LineWidth',1)
ylabel('probability')
xlabel('mean motor variability (deg)')
ax = gca;
ax.TickDir = 'out';
xlim([sigmaMotorMean(1),sigmaMotorMean(end)])
title('Figure 5-S3D')

subplot(3,4,10)
hold on
plot(outputTE(:,5),outputTI(:,5),'.b')
plot([min(outputTE(:,5)),max(outputTE(:,5))],[min(outputTE(:,5)),max(outputTE(:,5))],'-k')
xlim([min(outputTE(:,5)),max(outputTE(:,5))])
ax = gca;
ax.TickDir = 'out';
xlabel('R^2 explicit-total')
ylabel('R^2 implicit-total')