function [cost] = costfunCompetition(pars,yL1,yH1,yL2,yH2,r1,r2,tL1,tH1,tL2,tH2,c1,c2)
% cost function for fmincon

% the parameters are
% aI , aE , bI1 , bI2 , bE1 , bE2

% simulate the two-state model for this parameter set
[~,xI1,xE1] = simulateTwoStateCompetition(pars([1,2,3,5]),r1,c1);
[~,xI2,xE2] = simulateTwoStateCompetition(pars([1,2,4,6]),r2,c2);

% construct low and high for first exposure
yLM1 = xI1;
yHM1 = xI1 + xE1;

% construct low and high for second exposure
yLM2 = xI2;
yHM2 = xI2 + xE2;

% compute the squared error cost
cost = nansum((yL1 - yLM1(tL1)).^2) + nansum((yH1 - yHM1(tH1)).^2) + ...
    nansum((yL2 - yLM2(tL2)).^2) + nansum((yH2 - yHM2(tH2)).^2);

end