function [] = displayFitCompetition(output)

% get necessary data
P = output.Psubject;

% iterate through each subject
r1 = output.r1;
r2 = output.r2;
c1 = output.c1;
c2 = output.c2;
xI1 = [];
xE1 = [];
xI2 = [];
xE2 = [];
for s = 1 : 14
    [~,xI1(:,s),xE1(:,s)] = simulateTwoStateCompetition(P([1,2,3,5],s),r1,c1); %#ok<*AGROW>
    [~,xI2(:,s),xE2(:,s)] = simulateTwoStateCompetition(P([1,2,4,6],s),r2,c2); 
end

% get data
tL1 = output.tL1;
tL2 = output.tL2;
tH1 = output.tH1;
tH2 = output.tH2;
yL1 = output.yL1.subject;
yL2 = output.yL2.subject;
yH1 = output.yH1.subject;
yH2 = output.yH2.subject;

% total behavior
yL1M = xI1;
yH1M = xI1 + xE1;
yL2M = xI2;
yH2M = xI2 + xE2;

figure
hold on
t1 = min(tH1);
t2 = max(tH1);
m = nanmean(yL1,2); %#ok<*NANMEAN>
s = nanstd(yL1,[],2) / sqrt(14); %#ok<*NANSTD>
plot(tL1,m,'-k')
plot(tL1,m-s,'--k')
plot(tL1,m+s,'--k')
m = nanmean(yL1M,2);
s = nanstd(yL1M,[],2) / sqrt(14);
plot(t1:t2,m(t1:t2),'-b')
plot(t1:t2,m(t1:t2)-s(t1:t2),'--b')
plot(t1:t2,m(t1:t2)+s(t1:t2),'--b')

m = nanmean(yH1,2);
s = nanstd(yH1,[],2) / sqrt(14);
plot(tH1,m,'-k')
plot(tH1,m-s,'--k')
plot(tH1,m+s,'--k')
m = nanmean(yH1M,2);
s = nanstd(yH1M,[],2) / sqrt(14);
plot(t1:t2,m(t1:t2),'-g')
plot(t1:t2,m(t1:t2)-s(t1:t2),'--g')
plot(t1:t2,m(t1:t2)+s(t1:t2),'--g')

m = nanmean(xE1,2);
s = nanstd(xE1,[],2) / sqrt(14);
plot(t1:t2,m(t1:t2),'-m')
plot(t1:t2,m(t1:t2)-s(t1:t2),'--m')
plot(t1:t2,m(t1:t2)+s(t1:t2),'--m')

ax = gca;
ax.TickDir = 'out';
xlim([1,160])
ax.XTick = [1,40:40:160];
ax.YTick = 0 : 5 : 30;
xlim([1,160])
ylim([-5,30])

ylabel('reach angle (deg)')
xlabel('trial number')
title('Figure 6D, Column 1')

figure
hold on
t1 = min(tH2);
t2 = max(tH2);
m = nanmean(yL2,2);
s = nanstd(yL2,[],2) / sqrt(14);
plot(tL2,m,'-k')
plot(tL2,m-s,'--k')
plot(tL2,m+s,'--k')
m = nanmean(yL2M,2);
s = nanstd(yL2M,[],2) / sqrt(14);
plot(t1:t2,m(t1:t2),'-b')
plot(t1:t2,m(t1:t2)-s(t1:t2),'--b')
plot(t1:t2,m(t1:t2)+s(t1:t2),'--b')

m = nanmean(yH2,2);
s = nanstd(yH2,[],2) / sqrt(14);
plot(tH2,m,'-k')
plot(tH2,m-s,'--k')
plot(tH2,m+s,'--k')
m = nanmean(yH2M,2);
s = nanstd(yH2M,[],2) / sqrt(14);
plot(t1:t2,m(t1:t2),'-g')
plot(t1:t2,m(t1:t2)-s(t1:t2),'--g')
plot(t1:t2,m(t1:t2)+s(t1:t2),'--g')

m = nanmean(xE2,2);
s = nanstd(xE2,[],2) / sqrt(14);
plot(t1:t2,m(t1:t2),'-m')
plot(t1:t2,m(t1:t2)-s(t1:t2),'--m')
plot(t1:t2,m(t1:t2)+s(t1:t2),'--m')

ax = gca;
ax.TickDir = 'out';
xlim([1,160])
ax.XTick = [1,40:40:160];
ax.YTick = 0 : 5 : 30;
xlim([1,160])
ylim([-5,30])

ylabel('reach angle (deg)')
xlabel('trial number')
title('Figure 6D, Column 2')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%% data %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% show the model fit to the data, high and low separately
yL1m = nanmean(yL1,2);
yL1s = nanstd(yL1,[],2) / sqrt(14);
yL2m = nanmean(yL2,2);
yL2s = nanstd(yL2,[],2) / sqrt(14);
yH1m = nanmean(yH1,2);
yH1s = nanstd(yH1,[],2) / sqrt(14);
yH2m = nanmean(yH2,2);
yH2s = nanstd(yH2,[],2) / sqrt(14);

% plot the data
figure
hold on
plot(tL1,yL1m,'-k')
plot(tL1,yL1m-yL1s,'--k')
plot(tL1,yL1m+yL1s,'--k')
plot(tL2,yL2m,'-c')
plot(tL2,yL2m-yL2s,'--c')
plot(tL2,yL2m+yL2s,'--c')
ax = gca;
ax.TickDir = 'out';
xlim([1,160])
ax.XTick = [1 , 40 : 40 : 160];
ax.YTick = 0 : 5 : 30;
plot([20,20],[0,20],'--k')

ylabel('reach angle (deg)')
xlabel('trial number')
title('Figure 6B, middle column')

figure
hold on
plot(tH1,yH1m,'-k')
plot(tH1,yH1m-yH1s,'--k')
plot(tH1,yH1m+yH1s,'--k')
plot(tH2,yH2m,'-c')
plot(tH2,yH2m-yH2s,'--c')
plot(tH2,yH2m+yH2s,'--c')
ax = gca;
ax.TickDir = 'out';
xlim([1,160])
ax.XTick = [1 , 40 : 40 : 160];
ax.YTick = 0 : 5 : 30;
plot([20,20],[0,20],'--k')

yLm = nanmean(yL2-yL1,2);
yLs = nanstd(yL2-yL1,[],2) / sqrt(14);
yHm = nanmean(yH2-yH1,2);
yHs = nanstd(yH2-yH1,[],2) / sqrt(14);

ylabel('reach angle (deg)')
xlabel('trial number')
title('Figure 6B, left column')

% plot the data
figure
hold on
plot(tL1,yLm,'-k')
plot(tL1,yLm-yLs,'--k')
plot(tL1,yLm+yLs,'--k')
ax = gca;
ax.TickDir = 'out';
xlim([1,160])
ylim([-6,20])
ax.XTick = [1 , 40 : 40 : 160];
ax.YTick = 0 : 5 : 30;
plot([20,20],[0,20],'--k')

ylabel('difference (deg)')
xlabel('trial number')
title('Figure 6C, middle column')

figure
hold on
plot(tH1,yHm,'-k')
plot(tH1,yHm-yHs,'--k')
plot(tH1,yHm+yHs,'--k')
ax = gca;
ax.TickDir = 'out';
xlim([1,160])
ylim([-6,20])
ax.XTick = [1 , 40 : 40 : 160];
ax.YTick = 0 : 5 : 30;
plot([20,20],[0,20],'--k')

ylabel('difference (deg)')
xlabel('trial number')
title('Figure 6C, left column')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% test for differences in pre/post rotation difference
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
highDiff = yH2 - yH1;
iHBreak = find(tH1 > 20 , 1 , 'first');
highPre = highDiff(iHBreak-3:iHBreak-1,:);
highPost = highDiff(iHBreak:iHBreak+2,:);
highPre = nanmean(highPre);
highPost = nanmean(highPost);
lowDiff = yL2 - yL1;
iLBreak = find(tL1 > 20 , 1 , 'first');
lowPre = lowDiff(iLBreak-1,:);
lowPost = highDiff(iLBreak,:);

% replace anything in lowPre and lowPost with median
lowPre(isnan(lowPre)) = nanmean(lowPre);
lowPost(isnan(lowPost)) = nanmean(lowPost);

% plot the result
figure
hold on
m = mean(highPre);
s = std(highPre) / sqrt(length(highPre));
bar(1,m,'FaceColor','k')
plot([1,1],[m-s,m+s],'-k')

m = mean(highPost);
s = std(highPost) / sqrt(length(highPost));
bar(2,m,'FaceColor','c')
plot([2,2],[m-s,m+s],'-c')

% combine
H = [highPre;highPost];
plot([1.4,1.8],H,'.-k')

m = mean(lowPre);
s = std(lowPre) / sqrt(length(lowPre));
bar(4,m,'FaceColor','k')
plot([4,4],[m-s,m+s],'-k')

m = mean(lowPost);
s = std(lowPost) / sqrt(length(lowPost));
bar(5,m,'FaceColor','c')
plot([5,5],[m-s,m+s],'-c')

% combine
L = [lowPre;lowPost];
plot([4.4,4.8],L,'.-k')
ax = gca;
ax.TickDir = 'out';

ylabel('difference (deg)')
title('Figure 6C, right-most column')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%% fit exponential %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% load data to perform exponential fits
dd = load('exponential-data.mat');
yL1 = dd.yL1;
yL2 = dd.yL2;
yH1 = dd.yH1;
yH2 = dd.yH2;
tL1 = dd.tL1;
tH1 = dd.tH1;
yH1c = yH1(iHBreak-3:end,:);
yL1c = yL1(iLBreak-2:end,:);
yH2c = yH2(iHBreak-3:end,:);
yL2c = yL2(iLBreak-2:end,:);
tLc = tL1(iLBreak:end);
tHc = tH1(iHBreak:end);
tLc = [20 ; tLc];
tHc = [20 ; tHc];

% average across the first two trials
yH1c(3,:) = nanmean(yH1c(1:3,:));
yH1c(1:2,:) = [];
yL1c(2,:) = nanmean(yL1c(1:2,:));
yL1c(1,:) = [];
yH2c(3,:) = nanmean(yH2c(1:3,:));
yH2c(1:2,:) = [];
yL2c(2,:) = nanmean(yL2c(1:2,:));
yL2c(1,:) = [];

% the first subject in initial exposure low is all NaN
yL1c(1,1) = 0;

% subtract 20 from trial count
tLc = tLc - 20;
tHc = tHc - 20;

% iterate through each subject
expfun = @(x,y0,t) y0 + x(1) - x(1)*exp(-x(2)*t);
costfun = @(x,y0,t,y) nansum((y - expfun(x,y0,t)).^2); %#ok<*NANSUM>

% lower and upper bound
lb = [0,0];
ub = [30,2];

% iterate through each subject
PL1 = zeros(2,14);
PL2 = zeros(2,14);
PH1 = zeros(2,14);
PH2 = zeros(2,14);
options = optimoptions('fmincon','Display','off');
for s = 1 : 14
    PL1(:,s) = fmincon(@(x)costfun(x,yL1c(1,s),tLc,yL1c(:,s)),[20,0.1],...
        [],[],[],[],lb,ub,[],options);
    PL2(:,s) = fmincon(@(x)costfun(x,yL2c(1,s),tLc,yL2c(:,s)),[20,0.1],...
        [],[],[],[],lb,ub,[],options);
    PH1(:,s) = fmincon(@(x)costfun(x,yH1c(1,s),tHc,yH1c(:,s)),[20,0.1],...
        [],[],[],[],lb,ub,[],options);
    PH2(:,s) = fmincon(@(x)costfun(x,yH2c(1,s),tHc,yH2c(:,s)),[20,0.1],...
        [],[],[],[],lb,ub,[],options);    
end

% get the rate parameter
PL1 = PL1(2,:);
PL2 = PL2(2,:);
PH1 = PH1(2,:);
PH2 = PH2(2,:);

% bootstrap to get error-bars
mL1 = median(PL1);
sL1 = bootstrapSEM(PL1,10000,'median');
mL2 = median(PL2);
sL2 = bootstrapSEM(PL2,10000,'median');
mH1 = median(PH1);
sH1 = bootstrapSEM(PH1,10000,'median');
mH2 = median(PH2);
sH2 = bootstrapSEM(PH2,10000,'median');

figure
hold on
bar(1,mH1,'FaceColor','k')
plot([1,1],[mH1-sH1,mH1+sH1])
bar(2,mH2,'FaceColor','c')
plot([2,2],[mH2-sH2,mH2+sH2])
bar(4,mL1,'FaceColor','k')
plot([4,4],[mL1-sL1,mL1+sL1])
bar(5,mL2,'FaceColor','c')
plot([5,5],[mL2-sL2,mL2+sL2])
ax = gca;
ax.TickDir = 'out';

% plot individual subjects
H = [PH1;PH2];
L = [PL1;PL2];
plot([1.4,1.8],H,'.-k')
plot([4.4,4.8],L,'.-k')
ylabel('learning rate (1/trial)')
title('Figure 6B, right-most column')

% the individual subject parameters
figure
hold on
P = output.Psubject;
m = mean(P,2);
s = std(P,[],2) / sqrt(14);
bar(1,m(3),'FaceColor','b')
plot([1,1],[m(3)-s(3),m(3)+s(3)])
bar(2,m(4),'FaceColor','b')
plot([2,2],[m(4)-s(4),m(4)+s(4)])

bar(4,m(5),'FaceColor','r')
plot([4,4],[m(5)-s(5),m(5)+s(5)])
bar(5,m(6),'FaceColor','r')
plot([5,5],[m(6)-s(6),m(6)+s(6)])

ax = gca;
ax.TickDir = 'out';
ax.YTick = 0 : 0.1 : 0.3;

L = [P(3,:) ; P(4,:)];
plot([1.4,1.8],L,'.-k')

H = [P(5,:) ; P(6,:)];
plot([4.4,4.8],H,'.-k')

ylabel('error sensitivity')
title('Figure 6D, 3rd column')