function [] = displayFitIndependence(output)

% the individual subject parameters
figure
hold on
P = output.Psubject;
m = mean(P,2);
s = std(P,[],2) / sqrt(14);
bar(1,m(3),'FaceColor','b')
plot([1,1],[m(3)-s(3),m(3)+s(3)])
bar(2,m(4),'FaceColor','b')
plot([2,2],[m(4)-s(4),m(4)+s(4)])

bar(4,m(5),'FaceColor','r')
plot([4,4],[m(5)-s(5),m(5)+s(5)])
bar(5,m(6),'FaceColor','r')
plot([5,5],[m(6)-s(6),m(6)+s(6)])

ax = gca;
ax.TickDir = 'out';
ax.YTick = 0 : 0.04 : 0.6;

D = [P(3,:);P(4,:)];
plot([1.4,1.8],D,'.-k')

D = [P(5,:);P(6,:)];
plot([4.4,4.8],D,'.-k')

ylabel('error sensitivity')
title('Figure 6E')