function [y1Low,y2Low,y1High,y2High,t1Low,t2Low,t1High,t2High,c1,c2] = getY(data)

% get the data and the trial numbers for each day
y1High = squeeze(data{3}{2,1}.reachDir(:,:,2))';
y2High = squeeze(data{3}{2,1}.reachDir(:,:,3))';
y1Low = squeeze(data{3}{2,2}.reachDir(:,:,2))';
y2Low = squeeze(data{3}{2,2}.reachDir(:,:,3))';
t1High = data{3}{2,1}.trialNums;
t2High = data{3}{2,1}.trialNums;
t1Low = data{3}{2,2}.trialNums;
t2Low = data{3}{2,2}.trialNums;

% clip the data up until trial 160
idxStopHigh1 = find(t1High > 160,1,'first');
y1High = y1High(1:idxStopHigh1-1,:);
t1High = t1High(1:idxStopHigh1-1);

idxStopLow1 = find(t1Low > 160,1,'first');
y1Low = y1Low(1:idxStopLow1-1,:);
t1Low = t1Low(1:idxStopLow1-1);

idxStopHigh2 = find(t2High > 160,1,'first');
y2High = y2High(1:idxStopHigh2-1,:);
t2High = t2High(1:idxStopHigh2-1);

idxStopLow2 = find(t2Low > 160,1,'first');
y2Low = y2Low(1:idxStopLow2-1,:);
t2Low = t2Low(1:idxStopLow2-1);

% determine the trials for the adapted target
c1 = zeros(200,1);
c2 = zeros(200,1);
for n = 1 : 200
    flag = false;
    for i = 1 : length(t1Low)
        if n == t1Low(i)
            flag = true;
        end
    end
    for i = 1 : length(t1High)
        if n == t1High(i)
            flag = true;
        end
    end
    if flag
        c1(n) = 1;
    else
        c1(n) = 0;
    end
end
for n = 1 : 200
    flag = false;
    for i = 1 : length(t2Low)
        if n == t2Low(i)
            flag = true;
        end
    end
    for i = 1 : length(t2High)
        if n == t2High(i)
            flag = true;
        end
    end
    if flag
        c2(n) = 1;
    else
        c2(n) = 0;
    end
end

