function [] = figure7()

% parameters from fit to Haith et al. data
aS = 0.9829;
aF = 0.9278;
bS = 0.0629;
bF = 0.0632;

% change in error sensitivity (fractional)
schange = 0 : 0.001 : 2;
fchange = 0 : 0.001 : 2;

% steady-state learning calculations
xS_SS = zeros(length(schange),length(fchange));
for i = 1 : length(schange)
    for j = 1 : length(fchange)
        % implicit and explicit error sensitivity
        BS = bS*schange(i);
        BF = bF*fchange(j);
        
        % calculate steady-state
        xS_SS(i,end-j+1) = BS*(1-aF)/((1-aS+BS)*(1-aF+BF) - BS*BF);
    end
end

% initial asymptote
xS0 = bS*(1-aF)/((1-aS+bS)*(1-aF+bF) - bS*bF);

% calculate relative change in asymptote
xS_SS = 100 * (xS_SS - xS0) / xS0;
xS_SS(end,1) = 33;

% color coding
% 100 for negative
% 33 for positive
J = winter(2200);
c1 = J(1:2000,:);
c2 = spring(670);
c = [c1 ; c2];

% plot the map
figure
imagesc([-100,100],[-100,100],xS_SS')
colormap(c)
colorbar
xlim([-100,100])
ylim([-100,100])
ax = gca;
ax.TickDir = 'out';
ax.XTick = -100 : 50 : 100;
ax.YTick = -100 : 50 : 100;

% plot +/- 5% change threshold (encloses the black region)
s = (1-aS);
f = (1-aF);
bf1 = bF;
bs1 = bS;
Z = 1.05;
xs = 0:0.1:2;
xfa = xs*(s*f+s*bf1+f*bs1-Z*f*bs1)/(Z*s*bf1) - f/bf1;
Z = 0.95;
xfb = xs*(s*f+s*bf1+f*bs1-Z*f*bs1)/(Z*s*bf1) - f/bf1;
hold on
plot(100*(xs-1),-100*(xfa-1),'-k')
plot(100*(xs-1),-100*(xfb-1),'-k')
ylabel('actual change in explicit error sensitivity (%)')
xlabel('actual change in implicit error sensitivity (%)')
title('Figure 7A')

% plot the simulation examples
fHandle = figure;
simulatePureExplicitChange(fHandle);
simulateSavings(fHandle);

end