function [] = figure8()

% load the data
load('data-experiment-4.mat','A','RT');

% determine the number of subjects
numSubjects = size(A,2);

% plot the reaction times
fHandle = figure;
subplot(3,4,2)
hold on
m1 = nanmean(RT(1:70,:),2);
s1 = nanstd(RT(1:70,:),[],2) / sqrt(numSubjects);
m2 = nanmean(RT(131:end,:),2);
s2 = nanstd(RT(131:end,:),[],2) / sqrt(numSubjects);
plot(m1,'-k')
plot(m1-s1,'--k')
plot(m1+s1,'--k')
plot(m2,'-c')
plot(m2-s2,'--c')
plot(m2+s2,'--c')
ax = gca;
ax.TickDir = 'out';
title('Figure 8B')
ylabel('PT (ms)')
ax.XTick = [1,20:20:60];
xlim([1,length(m1)])


% reach angles during the first and second exposure
exposure1 = -A(1:70,:);
exposure2 = -A(131:end,:);
subplot(3,4,6)
hold on
m1 = nanmean(exposure1,2);
s1 = nanstd(exposure1,[],2) / sqrt(size(exposure1,2));
m2 = nanmean(exposure2,2);
s2 = nanstd(exposure2,[],2) / sqrt(size(exposure2,2));
plot(nanmean(m1,2),'-k')
plot(nanmean(m1-s1,2),'--k')
plot(nanmean(m1+s1,2),'--k')
plot(nanmean(m2,2),'-c')
plot(nanmean(m2-s2,2),'--c')
plot(nanmean(m2+s2,2),'--c')
plot([10,10],[0,25],'--k')
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,20:20:60];
xlim([1,length(m1)])
ylabel('implicit reach angle (deg)')

subplot(3,4,10)
hold on
exposure1 = -A(1:70,:);
exposure2 = -A(131:end,:);
m = nanmean(exposure2 - exposure1,2);
s = nanstd(exposure2 - exposure1,[],2) / sqrt(size(exposure1,2));
% plot the baseline and rotation period different colors
plot(1:10,m(1:10),'-k')
plot(1:10,m(1:10)-s(1:10),'--k')
plot(1:10,m(1:10)+s(1:10),'--k')
plot(10:70,m(10:end),'-','Color',[218 165 32]/255)
plot(10:70,m(10:end)-s(10:end),'--','Color',[218 165 32]/255)
plot(10:70,m(10:end)+s(10:end),'--','Color',[218 165 32]/255)
plot([10,10],[0,25],'--k')
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,20:20:60];
ylim([-5,12])
xlim([1,length(m1)])
xlabel('epoch number')
ylabel('change in implicit (deg)')

% fit an exponential to the behavior
expfun = @(x,y0,t) y0 + x(1) - x(1)*exp(-x(2)*t);
costfun = @(x,y0,t,y) nansum((y - expfun(x,y0,t)').^2); %#ok<*NANSUM>
PP1 = zeros(2,numSubjects);
PP2 = zeros(2,numSubjects);
x0 = [30 , 0.1];
lb = [0 , 0];
ub = [100 , 1000];
% remove the baseline period
exposure1 = exposure1(11:end,:);
exposure2 = exposure2(11:end,:);
for s = 1 : numSubjects
    PP1(:,s) = fmincon(@(x)costfun(x,exposure1(1,s),0:59,exposure1(:,s)),x0,[],[],[],[],lb,ub);
    PP2(:,s) = fmincon(@(x)costfun(x,exposure2(1,s),0:59,exposure2(:,s)),x0,[],[],[],[],lb,ub);
end
m1 = median(PP1(2,:));
s1 = bootstrapSEM(PP1(2,:),10000,'median');
m2 = median(PP2(2,:));
s2 = bootstrapSEM(PP2(2,:),10000,'median');

% plot results
subplot(3,4,7)
hold on
bar(5,m1,'FaceColor','k')
plot([5,5],[m1-s1,m1+s1],'-k');
bar(6,m2,'FaceColor','c')
plot([6,6],[m2-s2,m2+s2],'-c');
ax = gca;
ax.TickDir = 'out';
ylabel('learning rate (1/trial)')
title('Figure 8C')

% plot individual data points
subplot(3,4,8)
hold on
for s = 1 : numSubjects
    plot([5,6],[PP1(2,s),PP2(2,s)],'-','Color',[218 165 32]/255)
end
plot(5*ones(size(PP1(2,:))),PP1(2,:),'.k')
plot(6*ones(size(PP2(2,:))),PP2(2,:),'.c')
ax = gca;
ax.TickDir = 'out';
ax.YTick = 0 : 0.2 : 0.8;
ylim([-0.05,0.8])

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%% testing for differences %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

subplot(3,4,11)
hold on
exposure1 = -A(1:70,:);
exposure2 = -A(131:end,:);
% get trials before and after rotation onset
e1pre = nanmean(exposure1(6:10,:));
e1post = nanmean(exposure1(11:15,:));
e2pre = nanmean(exposure2(6:10,:));
e2post = nanmean(exposure2(11:15,:));
e1diff = e1post-e1pre;
e2diff = e2post-e2pre;
m = mean(e1diff);
s = std(e1diff) / sqrt(numSubjects);
bar(5,m,'FaceColor','k','EdgeColor','k')
plot([5,5],[m-s,m+s],'-k')
m = mean(e2diff);
s = std(e2diff) / sqrt(numSubjects);
bar(6,m,'FaceColor',[218 165 32]/255,'EdgeColor','k')
plot([6,6],[m-s,m+s],'Color',[218 165 32]/255)
ax = gca;
ax.TickDir = 'out';
ax.YTick = 0 : 2 : 10;
ylabel('implicit difference (deg')

% plot individuals
subplot(3,4,12)
hold on
DD = [e1diff;e2diff];
plot([5,6],DD,'-','Color',[218 165 32]/255)
plot(5,DD(1,:),'.k')
plot(6,DD(2,:),'.c')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Haith et al. data %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
cd haith

% load the data
load('data.mat','output');

% show the results
displayResults(output,fHandle);

cd ..