function [] = figure4DEF(fHandle)

% load the data
dd = load('data.mat');
meanS = dd.meanS;
totalS = dd.totalS;

% determine explicit angles
iS = meanS;
tS = totalS;
eS = tS - iS;

% the rotations
rS = repmat([15;30;45;60],1,size(iS,2));

% the driving force
dS = rS - eS;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% only stepwise B4 predictions %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure(fHandle);

% fit the competition model
i = iS(4,:)';
d = dS(4,:)';

% fit the gain
p = fit_competition(i,d);

% predict implicit learning with p
colors = {'k','m','b','r'};
r = [15,30,45,60];
for b = 1 : 4
    subplot(3,6,6+b)
    hold on
    iSub = p * (r(b) - eS(b,:));
    plot(eS(b,:),iSub,'-k')
    plot(eS(b,:),iS(b,:),'.','Color',colors{b})
end

err = zeros(3,37);
for b = 1 : 3
    iSub = p * (r(b) - eS(b,:));
    err(b,:) = iSub - iS(b,:);
end
errComp = sqrt(mean(err.^2));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% single subject gen SPE %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% fit the competition model
i = iS(4,:)';
e = eS(4,:)';

% the McDougle generalization function
A = 0.750491275538922;
m = (A-1)/22.5;

% fit a linear SPE generalization model
[p] = fit_lin(i,e,m,60*ones(size(e)));

% predict implicit learning with p
r = [15,30,45,60];
for b = 1 : 4
    % get the measure explicit strategy
    eMeasure = linspace(min(eS(b,:)),max(eS(b,:)),1000);
    
    % calculate implicit learning at each location
    iSub = xILin(eMeasure,p,r(b)*ones(size(eMeasure)),m);
    
    subplot(3,6,6+b)
    hold on
    plot(eMeasure,iSub,'-c')
end
ax = gca;
ax.TickDir = 'out';

% prediction error calculations
err = zeros(3,37);
for b = 1 : 3
    iSub = xILin(eS(b,:),p,r(b)*ones(size(eS(b,:))),m);
    err(b,:) = iSub - iS(b,:);
end
errDay = sqrt(mean(err.^2));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% McDougle normal %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% use a normal distribution with the McDougle et al. SD
sigma = 37.76;

% get the necessary data for fitting
i = iS(4,:)';
e = eS(4,:)';

p = fit_gauss(i,e,sigma,60*ones(size(e)));

% predict implicit learning with p
r = [15,30,45,60];
for b = 1 : 4
    % a range in strategies
    eMeasure = linspace(min(eS(b,:)),max(eS(b,:)),1000);
    
    % find iMeasure
    iSub = zeros(size(eMeasure));
    for ii = 1 : length(iSub)
        iSub(ii) = xIGauss(eMeasure(ii),p,r(b),sigma);
    end

    subplot(3,6,6+b)
    hold on
    plot(eMeasure,iSub,'--','Color',[255 140 0]/255)
end
ax = gca;
ax.TickDir = 'out';

% prediction error calculations
err = zeros(3,37);
for b = 1 : 3
    iSub = zeros(size(eS(b,:)));
    for s = 1 : length(eS(b,:))
        iSub(s) = xIGauss(eS(b,s),p,r(b),sigma);
    end
    err(b,:) = iSub - iS(b,:);
end
errMcDougleGauss = sqrt(mean(err.^2));

% run through and fix axes
xs = {-5:5:10,0:5:20,0:10:30,0:10:50};
for b = 1 : 4
    subplot(3,6,6+b)
    ylabel('implicit (deg)')
    xlabel('explicit (deg)')
    ylim([-5,50])
    ax = gca;
    ax.TickDir = 'out';
    ax.YTick = 0 : 10 : 50;
    ax.XTick = xs{b};
end
subplot(3,6,7)
title('Figure 4D')

subplot(3,6,11)
hold on
m = mean(errComp);
s = std(errComp) / sqrt(length(errComp));
bar(1,m,'FaceColor','k','EdgeColor','k')
plot([1,1],[m-s,m+s],'-k')

m = mean(errDay);
s = std(errDay) / sqrt(length(errDay));
bar(2,m,'FaceColor','c','EdgeColor','k')
plot([2,2],[m-s,m+s],'-k')

m = mean(errMcDougleGauss);
s = std(errMcDougleGauss) / sqrt(length(errMcDougleGauss));
bar(3,m,'FaceColor',[255 140 0]/255,'EdgeColor','k')
plot([3,3],[m-s,m+s],'-k')

ax = gca;
ax.TickDir = 'out';

ylabel('prediction error (deg)')
title('Figure 4E')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% evaluate each rotation period slope %%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
subplot(3,6,12)
hold on

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% predict slopes for the SPE gen model with McDougle parameters
Nstraps = 1000;
slopes = zeros(Nstraps,1);

% the day generalization function
A = 0.750491275538922;
m = (A-1)/22.5;

rr = [15,30,45,60];
for n = 1 : Nstraps
    % randomly samples participants
    idxS = randsample(size(dS,2),size(dS,2),1);
    i = iS(4,idxS);
    e = eS(4,idxS);
    
    % fit the model
    p = fit_lin(i,e,m,60*ones(size(e)));
    
    % now determine the slope in each rotation
    for b = 1 : 4
        slopes(n,b) = p*rr(b)*m/(1-p*rr(b)*m);
    end
end

% plot results
for b = 1 : 4
    vals = slopes(:,b);
    vals = sort(vals);
    i1 = floor(length(vals)*0.025);
    i2 = ceil(length(vals)*0.975);
    plot([rr(b)+4,rr(b)+4],[vals(i1),vals(i2)],'-c')
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% predict slopes for the McDougle Gaussian
% use a normal distribution with the McDougle et al. SD
sigma = 37.76;

slopes = zeros(Nstraps,4);
rr = [15,30,45,60];
for n = 1 : Nstraps
    % randomly samples participants
    idxS = randsample(size(dS,2),size(dS,2),1);
    i = iS(4,idxS)';
    e = eS(4,idxS)';
    
    % fit the competition model
    p = fit_gauss(i,e,sigma,60*ones(size(e)));
    
    % now determine the slope in each rotation
    for b = 1 : 4
        % must determine the slope via linear regression
        % cut out any points with negative strategies
        e(e<0) = [];
        ipred = xIGauss(e,p,rr(b)*ones(size(e)),sigma);
        ppp = polyfit(e,ipred,1);
        slopes(n,b) = ppp(1);
    end
end

% plot results
for b = 1 : 4
    vals = slopes(:,b);
    vals = sort(vals);
    i1 = floor(length(vals)*0.025);
    i2 = ceil(length(vals)*0.975);
    plot([rr(b)+8,rr(b)+8],[vals(i1),vals(i2)],'-','Color',[255 140 0]/255)
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% the actual data %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% load the data
dd = load('data-linear.mat');
meanS = dd.meanS;
totalS = dd.totalS;

% determine explicit angles
iS = meanS;
tS = totalS;
eS = tS - iS;

% the driving force
dS = rS - eS;

% get each adaptation block in the stepwise group and fit a line using the
% regress function (to obtain CIs)
rr = [15,30,45,60];
for b = 1 : 4
    % get data for this block
    ii = iS(b,:);
    ee = eS(b,:);
    X = ee';
    y = ii';
    
    % fit a line with regression
    mdl = fitlm(X,y);
    CI = coefCI(mdl);
    m = mean(CI(2,:));
    v1 = CI(2,1);
    v2 = CI(2,2);
    plot([rr(b),rr(b)],[v1,v2],'-','Color',[166 123 91]/255)
    plot(rr(b),m,'.','Color',[166 123 91]/255)
end

% predict slopes for the competition model
% get the scaling factor (b/1-a+b)
Nstraps = 1000;
slopes = zeros(Nstraps,1);
for n = 1 : Nstraps
    % randomly samples participants
    idxS = randsample(size(dS,2),size(dS,2),1);
    iiS = iS(4,idxS);
    ddS = dS(4,idxS);
    
    % fit the competition model
    slopes(n) = fit_competition(iiS,ddS);
end

% plot results
for b = 1 : 4
    vals = -slopes;
    vals = sort(vals);
    i1 = floor(length(vals)*0.025);
    i2 = ceil(length(vals)*0.975);
    plot([rr(b)+2,rr(b)+2],[vals(i1),vals(i2)],'-k')
end

ax = gca;
ax.TickDir = 'out';
ylabel('regression slope')
title('Figure 4F')

end
