function [ranks] = figure4G(fHandle)

% load the data
dd = load('data.mat');
meanS = dd.meanS;
totalS = dd.totalS;

% determine angles
iS = meanS;
tS = totalS;
eS = tS - iS;

% the rotations
rS = repmat([15;30;45;60],1,size(iS,2));

% the driving force
dS = rS - eS;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% competition model %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% the competition model
fun = @(x,y,p) sum((x - p*y).^2);

% an array for the model error
LLcomp = zeros(37,1);

% iterate through each participant
for s = 1 : 37
    % get data for this participant
    iii = iS(:,s);
    ddd = dS(:,s);
    
    % fit model to participant data
    p = fminbnd(@(p)fun(iii,ddd,p),0,1);
    
    % get the prediction implicit learning
    iPred = p * ddd;
    
    % calculate the residuals
    RES = iPred - iii;
    
    % calculate the RMSE
    sigma = sqrt(mean(RES.^2));
    
    % the number of data points
    N = length(RES);
    
    % calculate the log-likelihood
    LLcomp(s) = -N*log(2*pi*sigma^2) - (1/(2*sigma^2)) * sum(RES.^2);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% single subject gen SPE %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% the McDougle generalization function
A = 0.750491275538922;
mSlope = (A-1)/22.5;

% an array for the model error
LLLinMc = zeros(37,1);

% an array for the rotations
rrr = [15 ; 30 ; 45 ; 60];

% iterate through each participant
for s = 1 : 37
    % get data for this participant
    iii = iS(:,s);
    eee = eS(:,s);
    
    % fit model to participant data
    p = fit_lin(iii,eee,mSlope,rrr);
    
    % get the prediction implicit learning
    iPred = xILin(eee,p,rrr,mSlope);
    
    % calculate the residuals
    RES = iPred - iii;
    
    % calculate the RMSE
    sigma = sqrt(mean(RES.^2));
    
    % the number of data points
    N = length(RES);
    
    % calculate the log-likelihood
    LLLinMc(s) = -N*log(2*pi*sigma^2) - (1/(2*sigma^2)) * sum(RES.^2);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% McDougle normal %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% use a normal distribution with the McDougle et al. SD
sSigma = 37.76;

% an array for the model error
LLNormMc = zeros(37,1);

% an array for the rotations
rrr = [15 ; 30 ; 45 ; 60];

% iterate through each participant
for s = 1 : 37
    % get data for this participant
    iii = iS(:,s);
    eee = eS(:,s);
    
    % fit model to participant data
    p = fit_gauss(iii,eee,sSigma,rrr);
    
    % get the prediction implicit learning
    iPred = xIGauss(eee,p,rrr,sSigma);
    
    % calculate the residuals
    RES = iPred - iii;
    
    % calculate the RMSE
    sigma = sqrt(mean(RES.^2));
    
    % the number of data points
    N = length(RES);
    
    % calculate the log-likelihood
    LLNormMc(s) = -N*log(2*pi*sigma^2) - (1/(2*sigma^2)) * sum(RES.^2);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%% AIC calculations %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% calculate the AIC
AICcomp = 2 - 2 * LLcomp;
AICLinMc = 2 - 2 * LLLinMc;
AICNormMc = 2 - 2 * LLNormMc;

% combine together
AIC = [AICcomp,AICLinMc,AICNormMc];

% results matrix
ranks = zeros(37,3);

% determine the minimum
for s = 1 : 37
    % get the data for this participant
    dd = AIC(s,:);
    
    % sort the data
    [~,idx] = sort(dd);
    
    % store in the ranks matrix
    ranks(s,:) = idx;
    
    % store the ranks
    for xx = 1 : length(idx)
        ranks(s,idx(xx)) = xx;
    end
end

ddd = sum(ranks == 1);
figure(fHandle)
subplot(3,6,15)
hold on
colors = {'k','c',[255 140 0]/255};
for n = 1 : 3
    bar(n,ddd(n),'FaceColor',colors{n},'EdgeColor','k')
end
ylabel('# participants explained')
ax = gca;
ax.TickDir = 'out';

% plot the AIC relative to competition
AICLinMc = AICLinMc - AICcomp;
AICNormMc = AICNormMc - AICcomp;

% plot the results
subplot(3,6,14)
hold on
idx = AICLinMc < 0;
plot(ones(sum(idx),1),AICLinMc(idx),'.c')
idx = AICLinMc >= 0;
plot(ones(sum(idx),1),AICLinMc(idx),'.k')

idx = AICNormMc < 0;
plot(2*ones(sum(idx),1),AICNormMc(idx),'.','Color',[255 140 0]/255)
idx = AICNormMc >= 0;
plot(2*ones(sum(idx),1),AICNormMc(idx),'.k')
ax = gca;
ax.TickDir = 'out';
ylabel('AIC (rel. to comp.')
title('Figure 4G')
