function [] = figure4H(fhandle)

% load the data
dd = load('data.mat');
meanS = dd.meanS;
totalS = dd.totalS;

% determine explicit angles
iS = meanS;
tS = totalS;
eS = tS - iS;

% the rotations
rS = repmat([15;30;45;60],1,size(iS,2));

% the driving force
dS = rS - eS;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% only stepwise B4 predictions %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% fit the competition model
i = iS(4,:)';
d = dS(4,:)';

% fit the gain
p = fit_competition(i,d);

% the fit error
r = [15 30 45 60];
err = zeros(3,37);
for b = 1 : 3
    iSub = p * (r(b) - eS(b,:));
    err(b,:) = iSub - iS(b,:);
end
errComp = sqrt(mean(err.^2));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% single subject gen SPE %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% fit the SPE model
i = iS(4,:)';
e = eS(4,:)';

% the McDougle generalization function
A = 0.750491275538922;
m = (A-1)/22.5;

% a range on m
nIters = 100;
ms = linspace(2*m,0.5*m,nIters);

% iterate through each m
errLinear = zeros(nIters,37);
for iter = 1 : length(ms)
    
    % fit a linear SPE generalization model
    [p] = fit_lin(i,e,ms(iter),60*ones(size(e)));
    
    % prediction error calculations
    err = zeros(3,37);
    for b = 1 : 3
        iSub = xILin(eS(b,:),p,r(b)*ones(size(eS(b,:))),ms(iter));
        err(b,:) = iSub - iS(b,:);
    end
    errLinear(iter,:) = sqrt(mean(err.^2));
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% McDougle normal %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% use a normal distribution with the McDougle et al. SD
sigma = 37.76;

% get the necessary data for fitting
i = iS(4,:)';
e = eS(4,:)';

% a range on m
ss = linspace(0.5*sigma,2*sigma,nIters);
percentchangeG = (ss-sigma)/sigma * 100;

% iterate through each m
errGaussian = zeros(nIters,37);

for iter = 1 : nIters
    p = fit_gauss(i,e,ss(iter),60*ones(size(e)));
    for b = 1 : 3
        iSub = zeros(size(eS(b,:)));
        for s = 1 : length(eS(b,:))
            iSub(s) = xIGauss(eS(b,s),p,r(b),ss(iter));
        end
        err(b,:) = iSub - iS(b,:);
    end
    errGaussian(iter,:) = sqrt(mean(err.^2));
end

figure(fhandle)
subplot(3,6,16)
hold on
m = mean(errLinear,2);
s = std(errLinear,[],2) / sqrt(37);
plot(percentchangeG,m,'-c')
plot(percentchangeG,m-s,'--c')
plot(percentchangeG,m+s,'--c')

m = mean(errGaussian,2);
s = std(errGaussian,[],2) / sqrt(37);
plot(percentchangeG,m,'-','Color',[255 140 0]/255)
plot(percentchangeG,m-s,'--','Color',[255 140 0]/255)
plot(percentchangeG,m+s,'--','Color',[255 140 0]/255)

m = mean(errComp);
s = std(errComp) / sqrt(length(errComp));
xx = linspace(-50,100,nIters);
plot(xx,m*ones(size(xx)),'-k')
plot(xx,(m-s)*ones(size(xx)),'--k');
plot(xx,(m+s)*ones(size(xx)),'--k');
ylim([0,4.5])
ylabel('prediction error (deg)')
xlabel('% change generalization')
title('Figure 4H')

% iterare through and calculate AIC
ms = zeros(size(ss));
for i = 1 : length(ss)
    xe = linspace(0,60,1000);
    y2 = exp(-0.5*(xe/ss(i)).^2);
    p = polyfit(xe,y2,1);
    ms(i) = p(1)*0.8409;
end

ranks = zeros(nIters,3);
for n = 1 : nIters
    ranks(n,:) = callAIC(meanS,totalS,ms(n),ss(n));   
end

figure(fhandle)
subplot(3,6,17)
hold on
colors = {'k','c',[255 140 0]/255};
for n = 1 : 3
    plot(percentchangeG,ranks(:,n),'-','Color',colors{n})
end
ax = gca;
ax.TickDir = 'out';
ylabel('# participants explained')
xlabel('% change generalization')