function [output] = bootstrapSEM(x,Nstraps,type)

% the number of samples
N = length(x);

% iterate through the number of straps
v = zeros(Nstraps,1);
for s = 1 : Nstraps
    % sample with replacement
    ii = randsample(N,N,1);
    xs = x(ii);
    if strcmp(type,'median')
        v(s) = median(xs);
    else
        v(s) = mean(xs);
    end
end

% return the standard error
output = std(v);