function [] = displayResults(output,fHandle)

% diagram the forced rxn time
figure(fHandle)
subplot(3,4,1)
hold on
plot([-1.5,-0.3],[0,0],'-k','LineWidth',1)
plot([-0.3,-0.3],[0,1],'-k','LineWidth',1)
plot([-0.3,0],[1,1],'-k','LineWidth',1)
title('Figure 8A')
ax = gca;
ax.TickDir = 'out';

% get data
tL1 = output.tL1;
tL2 = output.tL2;
yL1 = output.yL1.subject;
yL2 = output.yL2.subject;
yH1 = output.yH1.subject;
yH2 = output.yH2.subject;

% show the model fit to the data, high and low separately
yL1m = nanmean(yL1,2);
yL1s = nanstd(yL1,[],2) / sqrt(14);
yL2m = nanmean(yL2,2);
yL2s = nanstd(yL2,[],2) / sqrt(14);

% plot the data
subplot(3,4,5)
hold on
plot(tL1,yL1m,'-k')
plot(tL1,yL1m-yL1s,'--k')
plot(tL1,yL1m+yL1s,'--k')
plot(tL2,yL2m,'-c')
plot(tL2,yL2m-yL2s,'--c')
plot(tL2,yL2m+yL2s,'--c')
ax = gca;
ax.TickDir = 'out';
xlim([1,160])
ax.XTick = [1 , 40 : 40 : 160];
ax.YTick = 0 : 5 : 30;
plot([20,20],[0,20],'--k')
ylabel('implicit reach angle (deg)')

% the change in low preparation time
yLm = nanmean(yL2-yL1,2);
yLs = nanstd(yL2-yL1,[],2) / sqrt(14);

% plot the data
subplot(3,4,9)
hold on
plot(tL1(1:2),yLm(1:2),'-k')
plot(tL1(1:2),yLm(1:2)-yLs(1:2),'--k')
plot(tL1(1:2),yLm(1:2)+yLs(1:2),'--k')
plot(tL1(2:end),yLm(2:end),'-m')
plot(tL1(2:end),yLm(2:end)-yLs(2:end),'--m')
plot(tL1(2:end),yLm(2:end)+yLs(2:end),'--m')
ax = gca;
ax.TickDir = 'out';
xlim([1,160])
ylim([-5,12])
ax.XTick = [1 , 40 : 40 : 160];
ax.YTick = 0 : 5 : 30;
plot([20,20],[0,20],'--k')
ylabel('change in implicit (deg)')
xlabel('trial number')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% test for differences in pre/post rotation difference
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
highDiff = yH2 - yH1;
lowDiff = yL2 - yL1;
iLBreak = find(tL1 > 20 , 1 , 'first');
lowPre = lowDiff(iLBreak-1,:);
lowPost = highDiff(iLBreak,:);

% replace anything in lowPre and lowPost with median
lowPre(isnan(lowPre)) = nanmean(lowPre);
lowPost(isnan(lowPost)) = nanmean(lowPost);

% plot the result
subplot(3,4,11)
hold on

m = mean(lowPre);
s = std(lowPre) / sqrt(length(lowPre));
bar(1,m,'FaceColor','k','EdgeColor','k')
plot([1,1],[m-s,m+s],'-k')

m = mean(lowPost);
s = std(lowPost) / sqrt(length(lowPost));
bar(2,m,'FaceColor','m','EdgeColor','k')
plot([2,2],[m-s,m+s],'-m')

% combine
subplot(3,4,12)
hold on
L = [lowPre;lowPost];
plot([1,2],L,'-m')
plot(1,L(1,:),'.k')
plot(2,L(2,:),'.c')
ax = gca;
ax.TickDir = 'out';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%% fit exponential %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% load data to perform exponential fits
dd = load('exponential-data.mat');
yL1 = dd.yL1;
yL2 = dd.yL2;
tL1 = dd.tL1;
yL1c = yL1(iLBreak-2:end,:);
yL2c = yL2(iLBreak-2:end,:);
tLc = tL1(iLBreak:end);
tLc = [20 ; tLc];

% average across the first two trials
yL1c(2,:) = nanmean(yL1c(1:2,:));
yL1c(1,:) = [];
yL2c(2,:) = nanmean(yL2c(1:2,:));
yL2c(1,:) = [];

% the first subject in initial exposure low is all NaN
yL1c(1,1) = 0;

% subtract 20 from trial count
tLc = tLc - 20;

% iterate through each subject
expfun = @(x,y0,t) y0 + x(1) - x(1)*exp(-x(2)*t);
costfun = @(x,y0,t,y) nansum((y - expfun(x,y0,t)).^2); %#ok<*NANSUM>

% lower and upper bound
lb = [0,0];
ub = [30,2];

% iterate through each subject
PL1 = zeros(2,14);
PL2 = zeros(2,14);
options = optimoptions('fmincon','Display','off');
for s = 1 : 14
    PL1(:,s) = fmincon(@(x)costfun(x,yL1c(1,s),tLc,yL1c(:,s)),[20,0.1],...
        [],[],[],[],lb,ub,[],options);
    PL2(:,s) = fmincon(@(x)costfun(x,yL2c(1,s),tLc,yL2c(:,s)),[20,0.1],...
        [],[],[],[],lb,ub,[],options);
end

% get the rate parameter
PL1 = PL1(2,:);
PL2 = PL2(2,:);

% bootstrap to get error-bars
mL1 = median(PL1);
sL1 = bootstrapSEM(PL1,10000,'median');
mL2 = median(PL2);
sL2 = bootstrapSEM(PL2,10000,'median');

subplot(3,4,7)
hold on
bar(1,mL1,'FaceColor','k')
plot([1,1],[mL1-sL1,mL1+sL1],'-k')
bar(2,mL2,'FaceColor','c')
plot([2,2],[mL2-sL2,mL2+sL2],'-c')
ax = gca;
ax.TickDir = 'out';

% plot individual subjects
L = [PL1;PL2];
subplot(3,4,8)
hold on
plot([1,2],L,'-m')
plot(1,L(1,:),'.k')
plot(2,L(2,:),'.c')
ax = gca;
ax.TickDir = 'out';

