function [] = figure2ABC()

% load the data
dd = load('dataABC.mat');
iNSm = dd.iNSm; iNSs = dd.iNSs;
iSm = dd.iSm; iSs = dd.iSs;
eNSm = dd.eNSm; eNSs = dd.eNSs;
eSm = dd.eSm; eSs = dd.eSs;
y20NSm = dd.y20NSm; y20NSs = dd.y20NSs;
y40NSm = dd.y40NSm; y40NSs = dd.y40NSs;
y60NSm = dd.y60NSm; y60NSs = dd.y60NSs;
y20Sm = dd.y20Sm; y20Ss = dd.y20Ss;
y40Sm = dd.y40Sm; y40Ss = dd.y40Ss;
y60Sm = dd.y60Sm; y60Ss = dd.y60Ss;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% plot the behavior %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure
subplot(1,5,1)
hold on
plot(y20NSm,'-k')
plot(y20NSm-y20NSs,'--k')
plot(y20NSm+y20NSs,'--k')
plot(y20Sm,'-m')
plot(y20Sm-y20Ss,'--m')
plot(y20Sm+y20Ss,'--m')

% plot the implicit learning
bar(36,iNSm(1),2,'FaceColor','k','EdgeColor','k')
plot([36,36],[iNSm(1)-iNSs(1),iNSm(1)+iNSs(1)],'-k')
bar(38,iSm(1),2,'FaceColor','m','EdgeColor','m')
plot([38,38],[iSm(1)-iSs(1),iSm(1)+iSs(1)],'-m')

xlim([10,40])
ax = gca;
ax.TickDir = 'out';
ax.XTick = 10 : 10 : 40;
xlabel('epoch number')
title('Figure 2A')
ylim([-5,72])

subplot(1,5,2)
hold on
plot(y40NSm,'-k')
plot(y40NSm-y40NSs,'--k')
plot(y40NSm+y40NSs,'--k')
plot(y40Sm,'-m')
plot(y40Sm-y40Ss,'--m')
plot(y40Sm+y40Ss,'--m')

% plot the implicit learning
bar(36,iNSm(2),2,'FaceColor','k','EdgeColor','k')
plot([36,36],[iNSm(2)-iNSs(2),iNSm(2)+iNSs(2)],'-k')
bar(38,iSm(2),2,'FaceColor','m','EdgeColor','m')
plot([38,38],[iSm(2)-iSs(2),iSm(2)+iSs(2)],'-m')

xlim([10,40])
ax = gca;
ax.TickDir = 'out';
ax.XTick = 10 : 10 : 40;
xlabel('epoch number')
ylim([-5,72])

subplot(1,5,3)
hold on
plot(y60NSm,'-k')
plot(y60NSm-y60NSs,'--k')
plot(y60NSm+y60NSs,'--k')
plot(y60Sm,'-m')
plot(y60Sm-y60Ss,'--m')
plot(y60Sm+y60Ss,'--m')

bar(36,iNSm(3),2,'FaceColor','k','EdgeColor','k')
plot([36,36],[iNSm(3)-iNSs(3),iNSm(3)+iNSs(3)],'-k')
bar(38,iSm(3),2,'FaceColor','m','EdgeColor','m')
plot([38,38],[iSm(3)-iSs(3),iSm(3)+iSs(3)],'-m')

xlim([10,40])
ax = gca;
ax.TickDir = 'out';
ax.XTick = 10 : 10 : 40;
ylabel('reach angle (deg)')
xlabel('epoch number')
ylim([-5,72])

% store explicit marginals
eNSm_marginal = dd.eNSm_marginal;
eSm_marginal = dd.eSm_marginal; 
eNSs_marginal = dd.eNSs_marginal;
eSs_marginal = dd.eSs_marginal;

% plot marginals
subplot(1,5,4)
hold on
m = eNSm_marginal;
s = eNSs_marginal;
bar(1,m,'FaceColor','k','EdgeColor','k')
plot([1,1],[m-s,m+s],'-k')
m = eSm_marginal;
s = eSs_marginal;
bar(2,m,'FaceColor','m','EdgeColor','k')
plot([2,2],[m-s,m+s],'-k')
ylabel('explicit reach angle (deg)')
title('Figure 2B')

% store implicit marginals
iNSm_marginal = dd.iNSm_marginal;
iSm_marginal = dd.iSm_marginal; 
iNSs_marginal = dd.iNSs_marginal;
iSs_marginal = dd.iSs_marginal;

% plot marginals
subplot(1,5,5)
hold on
m = iNSm_marginal;
s = iNSs_marginal;
bar(1,m,'FaceColor','k','EdgeColor','k')
plot([1,1],[m-s,m+s],'-k')
m = iSm_marginal;
s = iSs_marginal;
bar(2,m,'FaceColor','m','EdgeColor','k')
plot([2,2],[m-s,m+s],'-k')
ylabel('implicit aftereffect (deg)')
title('Figure 2C')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% fit models and plot results %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% convert to SD
iNSs = iNSs * sqrt(10);
iSs = iSs * sqrt(10);
eNSs = eNSs * sqrt(10);
eSs = eSs * sqrt(10);

% the retention factor
a = 0.9853^3; % 9 trials during the exclusion period

% predict asymptote
asymptote = @(a,b,r,e) b*(r-e)/(1-a+b);

% the cost function
costfun = @(a,b,r,e,i) sum((i - asymptote(a,b,r,e)).^2);

% iterate through each strap
Nstraps = 10000;
r = [20,20,40,40,60,60];
V = zeros(Nstraps,6);
for n = 1 : Nstraps
    % sample data
    i20NS = normrnd(iNSm(1),iNSs(1),10,1);
    i40NS = normrnd(iNSm(2),iNSs(2),10,1);
    i60NS = normrnd(iNSm(3),iNSs(3),10,1);
    i20S = normrnd(iSm(1),iSs(1),10,1);
    i40S = normrnd(iSm(2),iSs(2),10,1);
    i60S = normrnd(iSm(3),iSs(3),10,1);
    e20NS = normrnd(eNSm(1),eNSs(1),10,1);
    e40NS = normrnd(eNSm(2),eNSs(2),10,1);
    e60NS = normrnd(eNSm(3),eNSs(3),10,1);
    e20S = normrnd(eSm(1),eSs(1),10,1);
    e40S = normrnd(eSm(2),eSs(2),10,1);
    e60S = normrnd(eSm(3),eSs(3),10,1);
    
    % calculate the mean
    i20NS = mean(i20NS);
    i40NS = mean(i40NS);
    i60NS = mean(i60NS);
    i20S = mean(i20S);
    i40S = mean(i40S);
    i60S = mean(i60S);
    e20NS = mean(e20NS);
    e40NS = mean(e40NS);
    e60NS = mean(e60NS);
    e20S = mean(e20S);
    e40S = mean(e40S);
    e60S = mean(e60S);   
    
    % wrap up for fit
    e = [e20NS,e20S,e40NS,e40S,e60NS,e60S];
    i = [i20NS,i20S,i40NS,i40S,i60NS,i60S];
    
    % get the optimal b
    b = fminbnd(@(b)costfun(a,b,r,e,i),0,1);
    
    % get the model prediction
    im = asymptote(a,b,r,e);
    V(n,:) = im;
end

% plot the marginal effect of awareness
Z = zeros(size(V,1),2);
Z(:,1) = (V(:,1)+V(:,3)+V(:,5))/3;
Z(:,2) = (V(:,2)+V(:,4)+V(:,6))/3;
m = mean(Z);
s = std(Z);
for n = 1 : 2
    bar(n+8,m(n),'FaceColor','b','EdgeColor','k')
    plot([n+8,n+8],[m(n)-s(n),m(n)+s(n)],'-k')
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%% SPE independence model %%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% the retention factor
a = 0.9853^3; % 9 trials during the exclusion period

% predict asymptote
asymptote = @(a,b,r,e) b*r/(1-a+b);

% the cost function
costfun = @(a,b,r,e,i) sum((i - asymptote(a,b,r,e)).^2);

% iterate through each strap
Nstraps = 10000;
r = [20,20,40,40,60,60];
V = zeros(Nstraps,6);
for n = 1 : Nstraps
    % sample data
    i20NS = normrnd(iNSm(1),iNSs(1),10,1);
    i40NS = normrnd(iNSm(2),iNSs(2),10,1);
    i60NS = normrnd(iNSm(3),iNSs(3),10,1);
    i20S = normrnd(iSm(1),iSs(1),10,1);
    i40S = normrnd(iSm(2),iSs(2),10,1);
    i60S = normrnd(iSm(3),iSs(3),10,1);
    e20NS = normrnd(eNSm(1),eNSs(1),10,1);
    e40NS = normrnd(eNSm(2),eNSs(2),10,1);
    e60NS = normrnd(eNSm(3),eNSs(3),10,1);
    e20S = normrnd(eSm(1),eSs(1),10,1);
    e40S = normrnd(eSm(2),eSs(2),10,1);
    e60S = normrnd(eSm(3),eSs(3),10,1);
    
    % calculate the mean
    i20NS = mean(i20NS);
    i40NS = mean(i40NS);
    i60NS = mean(i60NS);
    i20S = mean(i20S);
    i40S = mean(i40S);
    i60S = mean(i60S);
    e20NS = mean(e20NS);
    e40NS = mean(e40NS);
    e60NS = mean(e60NS);
    e20S = mean(e20S);
    e40S = mean(e40S);
    e60S = mean(e60S);   
    
    % wrap up for fit
    e = [e20NS,e20S,e40NS,e40S,e60NS,e60S];
    i = [i20NS,i20S,i40NS,i40S,i60NS,i60S];
    
    % get the optimal b
    b = fminbnd(@(b)costfun(a,b,r,e,i),0,1);
    
    % get the model prediction
    im = asymptote(a,b,r,e);
    V(n,:) = im;
end

% plot the marginal effect of awareness
Z = zeros(size(V,1),2);
Z(:,1) = (V(:,1)+V(:,3)+V(:,5))/3;
Z(:,2) = (V(:,2)+V(:,4)+V(:,6))/3;
m = mean(Z);
s = std(Z);
for n = 1 : 2
    bar(n+4,m(n),'FaceColor','g','EdgeColor','k')
    plot([n+4,n+4],[m(n)-s(n),m(n)+s(n)],'-k')
end
ax = gca;
ax.TickDir = 'out';