function [] = figure2_supplement2()

% change in implicit learning in Neville and Cressman
yvalue1 = 84.191/57.604*100-100;

% change in implicit learning in Exp. 1 (stepwise vs abrupt)
yvalue2 = 89.521/49.107*100-100;

% retention factors
as = [0.95,0.96,0.97,0.98,0.99];

% reference error sensitivity
b1s = linspace(0.1,0.35,5);

% run simulations
figure
for k = 1 : length(as)
    a = as(k);
    subplot(1,5,k)
    hold on
    for i = 1 : length(b1s)
        % reference error sensitivity
        b1 = b1s(i);
        % test error sensitivity
        b2 = linspace(b1,1,1000);
        
        % calculate the implicit learning gain
        p1 = b1 / (1 - a + b1);
        p2 = b2 ./ (1 - a + b2);
        
        % calculate the percent change in implicit learning
        percentIncrease = p2/p1*100 - 100;
        
        % plot the result
        plot(b2,percentIncrease)
    end
    
    % plot the experimental levels
    x = [0.1,1];
    plot(x,yvalue1*ones(size(x)),'--k')
    plot(x,yvalue2*ones(size(x)),'--k')
    xlim([0.1,1])
    ax = gca;
    ax.TickDir = 'out';
    title(num2str(a))
    
    if k == 1
        legend('b_{reference} = 0.1','b_{reference} = 0.1625','b_{reference} = 0.225',...
            'b_{reference} = 0.2875','b_{reference} = 0.35','','')
    end
end
subplot(1,5,1)
ylabel('% change in implicit steady-state')
subplot(1,5,3)
xlabel('steady-state implicit error sensitivity in a test condition')

