function [output] = fitDataCompetition(data,fitFlag)
% fit to mean subjects
% Period 1 and 2 are fit independently
% there are 6 parameters, bI and bE for E1 and E2, but only aI and aE

% set seed
rng(1)

% parameters for fitting
lb = [0,0,0,0,0,0];
ub = [1,1,1,1,1,1];
ICs = cell(10,1);
for n = 1 : numel(ICs)
    ICs{n} = [0.7+0.3*rand ; 0.7+0.3*rand ; 0.1*rand ; 0.3*rand ; 0.1*rand ; 0.3*rand];
end
options = optimoptions('fmincon','Display','none');

% the rotations
r1 = [zeros(20,1);30*ones(140,1);zeros(40,1)];
r2 = [zeros(20,1);30*ones(180,1)];

% get the data
[y1L,y2L,y1H,y2H,tL1,tL2,tH1,tH2,c1,c2] = getY(data);

% the first exposure
yL1 = nanmean(y1L,2);
yH1 = nanmean(y1H,2);

% the second exposure
yL2 = nanmean(y2L,2);
yH2 = nanmean(y2H,2);

% fit the data simultaneously
minCost = 1e6;

for n = 1 : numel(ICs)
    pars = fmincon(@(x)costfunCompetition(x,yL1,yH1,yL2,yH2,r1,r2,tL1,tH1,tL2,tH2,c1,c2),...
        ICs{n},[],[],[],[],lb,ub,[],options);
    C = costfunCompetition(pars,yL1,yH1,yL2,yH2,r1,r2,tL1,tH1,tL2,tH2,c1,c2);
    if C < minCost
        minCost = C;
        P = pars;
    end
end

% create the output
[~,xI1,xE1] = simulateTwoStateCompetition(P([1,2,3,5]),r1,c1);
[~,xI2,xE2] = simulateTwoStateCompetition(P([1,2,4,6]),r2,c2);
output.P = P;
output.r1 = r1;
output.r2 = r2;
output.c1 = c1;
output.c2 = c2;
output.xI1 = xI1;
output.xI2 = xI2;
output.xE1 = xE1;
output.xE2 = xE2;
output.tL1 = tL1;
output.tL2 = tL2;
output.tH1 = tH1;
output.tH2 = tH2;
output.yL1.mean = yL1;
output.yL2.mean = yL2;
output.yH1.mean = yH1;
output.yH2.mean = yH2;

if fitFlag
    % get the data
    [yL1,yL2,yH1,yH2,tL1,tL2,tH1,tH2,c1,c2] = getY(data);
    
    % determine the number of subjects
    Nsubjects = size(y1L,2);
    
    % if fitFlag is true, fits individual participants
    Psubject = zeros(6,Nsubjects);
    
    % iterate through each subject
    for s = 1 : Nsubjects
        minCost = 1e6;
        for n = 1 : numel(ICs)
            pars = fmincon(@(x)costfunCompetition(x,yL1(:,s),yH1(:,s),yL2(:,s),yH2(:,s),...
                r1,r2,tL1,tH1,tL2,tH2,c1,c2),...
                ICs{n},[],[],[],[],lb,ub,[],options);
            C = costfunCompetition(pars,yL1(:,s),yH1(:,s),yL2(:,s),yH2(:,s),...
                r1,r2,tL1,tH1,tL2,tH2,c1,c2);
            if C < minCost
                minCost = C;
                Psubject(:,s) = pars;
            end
        end
    end
    output.Psubject = Psubject;
    output.yL1.subject = yL1;
    output.yL2.subject = yL2;
    output.yH1.subject = yH1;
    output.yH2.subject = yH2;
end


