function [] = figure8_supplement1()

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Limit PT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% load the data
dd = load('data-experiment-3-limit-PT.mat');
A = dd.A;
E = dd.E;
num_subjects = length(E);
RT = dd.RT;

% plot the rotation
figure
subplot(3,2,1)
plot([zeros(10,1);30*ones(60,1)],'-k','LineWidth',1)
xlim([1,90])
ylim([-2,32])
ylabel('pert. (deg)')
title('Figure 8-S1A')
ax = gca;
ax.TickDir = 'out';

% the behavior
subplot(3,2,3)
hold on
m = nanmean(A,2);
s = nanstd(A,[],2) / sqrt(num_subjects);
plot(1:70,m(1:70),'-r')
plot(1:70,m(1:70)-s(1:70),'--r')
plot(1:70,m(1:70)+s(1:70),'--r')
plot(71:90,m(71:90),'-r')
plot(71:90,m(71:90)-s(71:90),'--r')
plot(71:90,m(71:90)+s(71:90),'--r')
xlim([1,90])
ylim([-3,26])
ax = gca;
ax.YTick = 0:5:25;
ax.TickDir = 'out';
ax.XTick = [1,15:15:90];
ylabel('reach angle (deg)')

% plot the reaction time
subplot(3,2,5)
hold on
m = nanmean(RT,2);
s = nanstd(RT,[],2) / sqrt(num_subjects);
plot(1:70,m(1:70),'-r')
plot(1:70,m(1:70)-s(1:70),'--r')
plot(1:70,m(1:70)+s(1:70),'--r')
plot(71:90,m(71:90),'-r')
plot(71:90,m(71:90)-s(71:90),'--r')
plot(71:90,m(71:90)+s(71:90),'--r')
xlim([1,90])
ylim([0.1,0.55])
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,15:15:90];
ylabel('preparation time (sec)')
xlabel('cycle number (trials 4x')

% the explicit measure
subplot(3,2,4)
hold on
m = mean(E);
s = std(E) / sqrt(length(E));
bar(1,m,'FaceColor','r','EdgeColor','k')
plot([1,1],[m-s,m+s],'-k')
plot(1*ones(size(E)),E,'.b')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% the decay only group %%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% load the data
dd = load('data-experiment-3-decay-only.mat');
A = dd.A;
E = dd.E;
num_subjects = length(E);
RT = dd.RT;

% the behavior
subplot(3,2,3)
hold on
m = nanmean(A,2);
s = nanstd(A,[],2) / sqrt(num_subjects);
plot(1:70,m(1:70),'-k')
plot(1:70,m(1:70)-s(1:70),'--k')
plot(1:70,m(1:70)+s(1:70),'--k')
plot(71:90,m(71:90),'-k')
plot(71:90,m(71:90)-s(71:90),'--k')
plot(71:90,m(71:90)+s(71:90),'--k')
xlim([1,90])
ylim([-3,26])
ax = gca;
ax.YTick = 0:5:25;
ax.TickDir = 'out';
ax.XTick = [1,15:15:90];
ylabel('reach angle (deg)')

% plot the reaction time
subplot(3,2,5)
hold on
m = nanmean(RT,2);
s = nanstd(RT,[],2) / sqrt(num_subjects);
plot(1:70,m(1:70),'-k')
plot(1:70,m(1:70)-s(1:70),'--k')
plot(1:70,m(1:70)+s(1:70),'--k')
plot(71:90,m(71:90),'-k')
plot(71:90,m(71:90)-s(71:90),'--k')
plot(71:90,m(71:90)+s(71:90),'--k')
xlim([1,90])
ylim([0.1,0.55])
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,15:15:90];
ylabel('preparation time (sec)')
xlabel('cycle number (trials 4x)')

% the explicit measure
subplot(3,2,4)
hold on
m = mean(E);
s = std(E) / sqrt(length(E));
bar(2,m,'FaceColor','k','EdgeColor','k')
plot([2,2],[m-s,m+s],'-k')
plot(2*ones(size(E)),E,'.m')
title('Figure 8-S1B')
ylabel('reach angle change (deg)')
ax = gca;
ax.TickDir = 'out';
ylim([-8,25])