function [] = simulateSavings(fHandle)
% baseline parameter set
aS = 0.9829;
aF = 0.9278;
bS = 0.0629;
bF = 0.0632;

r = 30*ones(200,1);
pars = [aS;aF;bS;bF];
EC = zeros(size(r));

% base simulation
[yBase,xS1,xF1] = simulateTwoState(pars,r,EC);

figure(fHandle)
subplot(3,4,7)
hold on
plot(xS1,'-k')
plot(xF1,'-','Color',[200 200 200]/255)
ax = gca;
ax.TickDir = 'out';

%%% 40% increase implicit, 70% explicit
PP = pars;
PP(3) = bS*1.4;
PP(4) = bF*1.7;

[yFigE,xS2,xF2] = simulateTwoState(PP,r,EC);

plot(xS2,'--k')
plot(xF2,'--','Color',[200 200 200]/255)
ylim([0,30])
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,50:50:200];
xlim([1,200])

subplot(3,4,11)
plot(xS2-xS1,'k')
xlim([1,200])
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1 , 50 : 50 : 200];
xlabel('Trial number')
ylim([-4,6])

subplot(3,4,3)
hold on
plot(yBase,'-k')
plot(yFigE,'--k')
ax = gca;
ax.TickDir = 'out';
xlim([1,200])
ax.XTick = [1 , 50 : 50 : 200];
title('Figure 7E')

%%%%%%%%%%%%%%% implicit only
aS = 0.9829;
aF = 0;
bS = 0.0629;
bF = 0;
pars = [aS;aF;bS;bF];

% base simulation
[yBase,xS1,xF1] = simulateTwoState(pars,r,EC);

subplot(3,4,8)
hold on
plot(xS1,'-r')
plot(xF1,'-','Color',[200 200 200]/255)
ax = gca;
ax.TickDir = 'out';

%%% 40% increase implicit, 70% explicit
PP = pars;
PP(3) = bS*1.4;

[yFigF,xS2,xF2] = simulateTwoState(PP,r,EC);
hold on
plot(xS2,'--r')
plot(xF2,'--','Color',[200 200 200]/255)
ylim([0,30])
xlim([1,200])
ax.XTick = [1 , 50 : 50 : 200];

subplot(3,4,12)
plot(xS2-xS1,'-r')
ax = gca;
ax.TickDir = 'out';
xlim([1,200])
ax.XTick = [1 , 50 : 50 : 200];
xlabel('Trial number')
ylim([-4,6])

subplot(3,4,4)
hold on
plot(yBase,'-k')
plot(yFigF,'--k')
ax = gca;
ax.TickDir = 'out';
xlim([1,200])
ax.XTick = [1 , 50 : 50 : 200];
title('Figure 7F')

end