function [] = figure5_supplement2()

% load the data for Experiment 1
dd = load('data-experiment-1.mat');

% plot T and I in the 30 deg period
figure
subplot(3,4,3)
plot(dd.tS(2,:),dd.iS(2,:),'.k')
ylabel('implicit angle (deg)')
xlabel('total adaptation (deg)')

% load the Tsay data
dd = load('data-tsay.mat');

% plot T and I in the 30 deg period
subplot(3,4,2)
plot(dd.t30,dd.i30,'.k')
ylabel('implicit angle (deg)')
xlabel('total adaptation (deg)')

% load the data in Experiment 3
dd = load('data-experiment-3.mat');

% plot T and I
subplot(3,4,1)
hold on
plot(dd.T,dd.I,'.k')
p = polyfit(dd.T,dd.I,1);
y = polyval(p,dd.T);
plot(dd.T,y,'-','Color',[70,54,33]/255,'LineWidth',1);
ylabel('implicit angle (deg)')
xlabel('total adaptation (deg)')
title('Figure 5-S2A')

% plot number of aftereffect trials
subplot(3,4,6)
hold on
bar(1,80,'FaceColor','b','EdgeColor','k')
bar(2,20,'FaceColor','m','EdgeColor','k')
bar(3,18,'FaceColor','g','EdgeColor','k')
ax = gca;
ax.TickDir = 'out';
ylabel('# of aftereffect trials')

% plot explicit strategy use in each experiment
subplot(3,4,12)
hold on
% Experiment 3
dd = load('data-experiment-3');
E = dd.E;
m = mean(E);
s = std(E) / sqrt(length(E));
bar(1,m,'FaceColor','b','EdgeColor','k')
plot([1,1],[m-s,m+s],'-k')
plot(ones(size(E)),E','.c')
ax = gca;
ax.TickDir = 'out';
ylabel('explicit strategy use (deg)')

% plot the standard deviation
subplot(3,4,10)
hold on
m = std(E);
bar(1,m,'FaceColor','b','EdgeColor','k')

% Tsay
subplot(3,4,12)
hold on
dd = load('data-tsay.mat');
E = dd.e30;
m = mean(E);
s = std(E) / sqrt(length(E));
bar(2,m,'FaceColor','m','EdgeColor','k')
plot([2,2],[m-s,m+s],'-k')
plot(2*ones(size(E)),E','.','Color',[93 63 211]/255)
ax = gca;
ax.TickDir = 'out';
ylabel('explicit strategy use (deg)')

% plot the standard deviation
subplot(3,4,10)
hold on
m = std(E);
bar(2,m,'FaceColor','m','EdgeColor','k')

% Experiment 1
subplot(3,4,12)
hold on
dd = load('data-experiment-1.mat');
E = dd.eS(2,:);
m = mean(E);
s = std(E) / sqrt(length(E));
bar(3,m,'FaceColor','g','EdgeColor','k')
plot([3,3],[m-s,m+s],'-k')
plot(3*ones(size(E)),E','.','Color',[34 139 34]/255)
ax = gca;
ax.TickDir = 'out';
ylabel('explicit strategy use (deg)')

% plot the standard deviation
subplot(3,4,10)
hold on
m = std(E);
bar(3,m,'FaceColor','g','EdgeColor','k')
ylabel('sub-sub var. in strat. (deg)')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% motor variability comparisons %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% load motor variability data
dd = load('variability-data.mat');
varE1 = dd.varE1;
varE3 = dd.varE3;
varTsay = dd.varTsay;

subplot(3,4,8)
hold on
m = mean(varE3);
s = std(varE3) / sqrt(length(varE3));
bar(1,m,'FaceColor','b','EdgeColor','k')
plot([1,1],[m-s,m+s])
plot(ones(size(varE3)),varE3,'.c')
m = mean(varTsay);
s = std(varTsay) / sqrt(length(varTsay));
bar(2,m,'FaceColor','m','EdgeColor','k')
plot([2,2],[m-s,m+s])
plot(2*ones(size(varTsay)),varTsay,'.','Color',[93 63 211]/255)
m = mean(varE1);
s = std(varE1) / sqrt(length(varE1));
bar(3,m,'FaceColor','g','EdgeColor','k')
plot([3,3],[m-s,m+s])
plot(3*ones(size(varE1)),varE1,'.','Color',[34 139 34]/255)
ax = gca;
ax.TickDir = 'out';
ylabel('reach angle SD, no FB (deg)')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% simulations %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% the simulations are time-consuming, so here we load data previously
% simulated, see simulation-code directory to simulate each data-set

% load data for explicit variability analysis
dd = load('explicit-variability-analysis.mat');
outputTI = dd.outputTI;
sigmaExplicit = dd.sigmaExplicit;
subplot(3,4,9)
hold on
plot(sigmaExplicit,outputTI(:,1),'-r','LineWidth',1)
plot(sigmaExplicit,outputTI(:,2),'-k','LineWidth',1)
plot(sigmaExplicit,outputTI(:,3),'-g','LineWidth',1)
ylabel('probability')
xlabel('sub-sub var. in strat. (deg)')
ax = gca;
ax.TickDir = 'out';
xlim([sigmaExplicit(1),sigmaExplicit(end)])
ax.YTick = 0:0.2:1;
title('Figure 5-S2D');

% load data for number of aftereffect trial analysis
dd = load('probe-trial-analysis.mat');
outputTI = dd.outputTI;
Nprobe = dd.Nprobe;
subplot(3,4,5)
hold on
plot(Nprobe,outputTI(:,1),'-r','LineWidth',1)
plot(Nprobe,outputTI(:,2),'-k','LineWidth',1)
plot(Nprobe,outputTI(:,3),'-g','LineWidth',1)
ylabel('probability')
xlabel('# aftereffect trials')
ax = gca;
ax.TickDir = 'out';
xlim([Nprobe(1),Nprobe(end)])
ax.YTick = 0:0.2:1;
title('Figure 5-S2B');

% load data for motor variability analysis
dd = load('motor-variability-analysis.mat');
outputTI = dd.outputTI;
sigmaMotorMean = dd.sigmaMotorMean;
subplot(3,4,7)
hold on
plot(sigmaMotorMean,outputTI(:,1),'-r','LineWidth',1)
plot(sigmaMotorMean,outputTI(:,2),'-k','LineWidth',1)
plot(sigmaMotorMean,outputTI(:,3),'-g','LineWidth',1)
ylabel('probability')
xlabel('mean motor var. (deg)')
ax = gca;
ax.TickDir = 'out';
xlim([sigmaMotorMean(1),sigmaMotorMean(end)])
ax.YTick = 0:0.2:1;
title('Figure 5-S2C')

% average strategy use analysis
dd = load('total-explicit-analysis.mat');
outputTI = dd.outputTI;
meanExplicit = dd.meanExplicit;
subplot(3,4,11)
hold on
plot(meanExplicit,outputTI(:,1),'-r','LineWidth',1)
plot(meanExplicit,outputTI(:,2),'-k','LineWidth',1)
plot(meanExplicit,outputTI(:,3),'-g','LineWidth',1)
ylabel('probability')
xlabel('avg. strat. use (deg)')
ax = gca;
ax.TickDir = 'out';
xlim([meanExplicit(1),meanExplicit(end)])
ax.YTick = 0:0.2:1;
title('Figure 5-S2E')

end