% the number of subjects
S = 30;

% range in implicit learning parameters
aRange = 0.05;
aMean = 0.925;
bRange = 0.1;
bMean = 0.25;

% iterate through many iterations
Niters = 40000;

% the number of total trials
Ntotal = 40;

% the rotation size
r = 30;

% mean of explicit learning
meanExplicit = 10;

% subject-to-subject variability in the explicit process
sigmaExplicit = 6;

% the motor variability on each trial
sigmaMotorMean = linspace(5,20,40);
sigmaMotorSTD = linspace(2,10,40);

% the number of probe trials
Nprobe = 40;

% outputs for each probe number
outputTI = nan(length(sigmaMotorMean),5);
outputTE = nan(length(sigmaMotorMean),5);
outputEI = nan(length(sigmaMotorMean),5);

% iterate through each
parfor s = 1 : length(sigmaMotorMean)
    [outputTI(s,:),outputTE(s,:),outputEI(s,:)] = ...
        runSimulation(S,sigmaMotorMean(s),sigmaMotorSTD(s),Ntotal,Nprobe,Nprobe,...
        aRange,aMean,bRange,bMean,r,meanExplicit,sigmaExplicit,Niters);
end

% plot each probability in a different color
figure
hold on
plot(sigmaMotorMean,outputTI(:,1),'-r')
plot(sigmaMotorMean,outputTI(:,2),'-k')
plot(sigmaMotorMean,outputTI(:,3),'-g')
ylabel('probability')
xlabel('motor var mean')
ax = gca;
ax.TickDir = 'out';
xlim([sigmaMotorMean(1),sigmaMotorMean(end)])

save('motor-variability-analysis','outputTI','outputTE','outputEI','sigmaMotorMean');