function [outputTI,outputTE,outputEI] = runSimulation(...
    S,sigmaMotorMean,sigmaMotorSTD,Ntotal,Nimplicit,Nexplicit,...
    aRange,aMean,bRange,bMean,r,meanExplicit,sigmaExplicit,Niters)

% matrices to store data
RTI = nan(Niters,1);
pTI = nan(Niters,1);
RTE = nan(Niters,1);
pTE = nan(Niters,1);
REI = nan(Niters,1);
pEI = nan(Niters,1);

% iterate through each iteration
for n = 1 : Niters
    [RTI(n),pTI(n),RTE(n),pTE(n),REI(n),pEI(n)] = ...
        simulateExperiment(S,sigmaMotorMean,sigmaMotorSTD,Ntotal,Nimplicit,Nexplicit,...
        aRange,aMean,bRange,bMean,r,meanExplicit,sigmaExplicit);
end

% determine the probability of each correlation
outputTI = zeros(1,4);
outputTI(1) = sum((RTI < 0) & (pTI < 0.05)) / Niters;
outputTI(2) = sum(pTI >= 0.05) / Niters;
outputTI(3) = sum((RTI > 0) & (pTI < 0.05)) / Niters;
outputTI(4) = mean(RTI);
outputTI(5) = mean(RTI.^2);

outputTE = zeros(1,4);
outputTE(1) = sum((RTE < 0) & (pTE < 0.05)) / Niters;
outputTE(2) = sum(pTE >= 0.05) / Niters;
outputTE(3) = sum((RTE > 0) & (pTE < 0.05)) / Niters;
outputTE(4) = mean(RTE);
outputTE(5) = mean(RTE.^2);

outputEI = zeros(1,4);
outputEI(1) = sum((REI < 0) & (pEI < 0.05)) / Niters;
outputEI(2) = sum(pEI >= 0.05) / Niters;
outputEI(3) = sum((REI > 0) & (pEI < 0.05)) / Niters;
outputEI(4) = mean(REI);
outputEI(5) = mean(REI.^2);
