function [RTI,pTI,RTE,pTE,REI,pEI] = simulateExperiment(S,sigmaMotorMean,...
    sigmaMotorSTD,Ntotal,Nimplicit,Nexplicit,...
    aRange,aMean,bRange,bMean,r,meanExplicit,sigmaExplicit)


% calculate min and max values
aImin = aMean - aRange / 2;
aImax = aMean + aRange / 2;
bImin = bMean - bRange / 2;
bImax = bMean + bRange / 2;

% generate different a and b values
a = aImin + (aImax - aImin) * rand(S,1);
b = bImin + (bImax - bImin) * rand(S,1);

% calculate pI
pI = b ./ (1 - a + b);

% calculate total explicit
xE = normrnd(meanExplicit,sigmaExplicit,S,1);

% motor variabilities for each participant
sigma = normrnd(sigmaMotorMean,sigmaMotorSTD,S,1);

% insure no negative standard deviations
sigma(sigma < 0) = 0;

% calculate total implicit
xI = pI .* (r - xE);

% iterate through each participant
xTotalSubjects = nan(S,1);
xImplicitSubjects = nan(S,1);
xExplicitSubjects = nan(S,1);
for s = 1 : S
     % simulate each measure across several noisy trials
     xTotalTrials = normrnd(xI(s) + xE(s),sigma(s),Ntotal,1);
     xImplicitTrials = normrnd(xI(s),sigma(s),Nimplicit,1);
     xExplicitTrials = normrnd(xE(s),sigma(s),Nexplicit,1);
     
     % get the mean across trials
     xTotalSubjects(s) = mean(xTotalTrials);
     xImplicitSubjects(s) = mean(xImplicitTrials);
     xExplicitSubjects(s) = mean(xExplicitTrials);
end

% calculate each correlation and significance
[~,~,~,~,STATS] = regress(xTotalSubjects,[ones(S,1),xImplicitSubjects]);
pTI = STATS(3);
C = corrcoef(xTotalSubjects,xImplicitSubjects);
RTI = C(1,2);

[~,~,~,~,STATS] = regress(xTotalSubjects,[ones(S,1),xExplicitSubjects]);
pTE = STATS(3);
C = corrcoef(xTotalSubjects,xExplicitSubjects);
RTE = C(1,2);

[~,~,~,~,STATS] = regress(xExplicitSubjects,[ones(S,1),xImplicitSubjects]);
pEI = STATS(3);
C = corrcoef(xExplicitSubjects,xImplicitSubjects);
REI = C(1,2);




