function [] = figure3_supplement2()

% load the data
dd = load('data.mat');
Ireach = dd.Ireach;
Ireport = dd.Ireport;
Ereach = dd.Ereach;
Ereport = dd.Ereport;

figure
subplot(1,5,1)
hold on
plot(Ereport,Ereach,'.k')
x = 0 : 1 : 25;
y = 0 : 1 : 25;
plot(x,y,'-k')
xlabel('report-based explicit (deg)')
ylabel('reach-based explicit (deg)')
ax = gca;
ax.TickDir = 'out';
ax.XTick = 0:5:25;
ax.YTick = 0:5:25;
title('Figure 3-S2A')

subplot(1,5,2)
hold on
m = mean(Ereport);
s = std(Ereport)/sqrt(length(Ereport));
bar(1,m,'FaceColor','m','EdgeColor','k')
plot([1,1],[m-s,m+s],'-k')
m = mean(Ereach);
s = std(Ereach)/sqrt(length(Ereach));
bar(2,m,'FaceColor','k','EdgeColor','k')
plot([2,2],[m-s,m+s],'-k')
ylabel('explicit angle (deg)')


subplot(1,5,3)
hold on
plot(Ireport,Ireach,'.k')
x = 4 : 1 : 24;
y = 4 : 1 : 24;
plot(x,y,'-k')
xlabel('report-based implicit (deg)')
ylabel('reach-based implicit (deg)')
ax = gca;
ax.TickDir = 'out';
ax.XTick = 4:4:24;
ax.YTick = 4:4:24;
title('Figure 3-S2B')

subplot(1,5,4)
hold on
m = mean(Ireport);
s = std(Ireport)/sqrt(length(Ireport));
bar(1,m,'FaceColor','c','EdgeColor','k')
plot([1,1],[m-s,m+s],'-k')
m = mean(Ireach);
s = std(Ireach)/sqrt(length(Ireach));
bar(2,m,'FaceColor','k','EdgeColor','k')
plot([2,2],[m-s,m+s],'-k')
ylabel('implicit angle (deg)')



% plot implicit and explicit report
subplot(1,5,5)
hold on
plot(Ereport,Ireport,'.k')
p = polyfit(Ereport,Ireport,1);
Ipred = polyval(p,Ereport);
plot(Ereport,Ipred,'-k')
ylabel('report-based implicit (deg)')
xlabel('report-based explicit (deg)')
title('Figure 3-S2C')
b = 0.35;
a = 0.943;
Ipred = b/(1-a+b)*(30-Ereport);
plot(Ereport,Ipred,'-b')