function [] = figure5_supplement4()

% set the random number generator seed
rng(13)

% simulate explicit strategies
xe = normrnd(12,4,35,1);

% calculate implicit learning via competition
pi = 0.8;
r = 30;
xi = pi*(r-xe);

% total adaptation
xt = xi + xe;

% plot correlations without implicit noise
figure
subplot(3,2,1)
hold on
plot(xt,xi,'.k')
ax = gca;
ax.TickDir = 'out';
ylabel('implicit angle (deg)')
xlabel('total adaptation (deg)')
title('Figure 5-S4A')

subplot(3,2,3)
plot(xt,xe,'.k')
ax = gca;
ax.TickDir = 'out';
ylabel('explicit angle (deg)')
xlabel('total adaptation (deg)')
title('Figure 5-S4B')

subplot(3,2,5)
plot(xe,xi,'.k')
ax = gca;
ax.TickDir = 'out';
ylabel('implicit angle (deg)')
xlabel('explicit angle (deg)')
title('Figure 5-S4C')

% simulate variability in implicit learning gain
% recalculate competition model model predictions for implicit, using the
% same strategies as above
pi = normrnd(0.8,0.1,35,1);
r = 30;
xi = pi.*(r-xe);
xt = xi + xe;

% plot the results (noise in implicit learning parameters)
subplot(3,2,2)
hold on
plot(xt,xi,'.k')
ax = gca;
ax.TickDir = 'out';
ylabel('implicit angle (deg)')
xlabel('total adaptation (deg)')

subplot(3,2,4)
plot(xt,xe,'.k')
ax = gca;
ax.TickDir = 'out';
ylabel('explicit angle (deg)')
xlabel('total adaptation (deg)')

subplot(3,2,6)
plot(xe,xi,'.k')
ax = gca;
ax.TickDir = 'out';
ylabel('implicit angle (deg)')
xlabel('explicit angle (deg)')

end