function [] = figure3_supplement1()
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Experiment 2 analysis %%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% load the data
dd = load('data-experiment-2.mat');

% load the trials for error sensivity calculation
trials = dd.trials;

% load the error sensitivities
b = dd.b;

% plot the error sensitivity over time
numSubjects = size(b,2);
m = nanmean(b,2);
s = nanstd(b,[],2) / sqrt(numSubjects);
% the steady-state error sensitivity
bSS = m(end);
figure
subplot(2,3,1)
hold on
plot(trials,m,'-k')
plot(trials,m-s,'--k')
plot(trials,m+s,'--k')
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,20:20:60];
ylabel('error sensitivity ')
yline(bSS,'--r')
xlim([1,60])
title('Figure 3-S1A')
xlabel('cycle number')

% load the reach angles
A = dd.A;

% convert to errors
A = 30 - A;

% calculate asymptotic error
asymptote = nanmean(A(61:70,:));

subplot(2,3,2)
hold on
m = nanmean(A,2);
s = nanstd(A,[],2) / sqrt(numSubjects);
plot(1:60,m(11:70),'-k')
plot(1:60,(m(11:70)-s(11:70)),'--k')
plot(1:60,(m(11:70)+s(11:70)),'--k')
xlim([1,60])
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,20:20:60];
m = mean(asymptote);
s = std(asymptote) / sqrt(length(asymptote));
eSSm = m;
eSSs = s;
plot([1,60],[m-s,m-s],'--c')
plot([1,60],[m+s,m+s],'--c')
plot([1,60],[m,m],'-c')
ylabel('target error (deg)')
xlabel('cycle number')
title('Figure 3-S1B')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%% compare error sensitivity to literature %%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% load the data for Kim et al. (2018) and Morehead et al. (2017)
dd = load('literature.mat');
x = dd.x1; y = dd.y1; s = dd.s1;

% plot the literature data
subplot(2,3,3)
hold on
plot(x,y,'.-k')
for n = 1 : length(x)
    plot([x(n),x(n)],[y(n)-s(n),y(n)+s(n)],'-k')
end
x = dd.x2; y = dd.y2; s = dd.s2;
plot(x,y,'.-b')
for n = 1 : length(x)
    plot([x(n),x(n)],[y(n)-s(n),y(n)+s(n)],'-b')
end
ylabel('error sensitivity')
xlabel('error (deg)')
title('Figure 3-S1C')

% plot the experimental data
plot([eSSm-eSSs,eSSm-eSSs],[0,0.6],'--c')
plot([eSSm+eSSs,eSSm+eSSs],[0,0.6],'--c')
plot([eSSm,eSSm],[0,0.6],'-c')
plot(eSSm,bSS,'rp')
ax = gca;
ax.TickDir = 'out';
ax.XTick = 0:10:40;
ax.YTick = 0:0.1:0.6;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%% Experiment 3 analysis %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% load the data
dd = load('data-experiment-3.mat');

% load the trials for error sensivity calculation
trials = dd.trials;

% load the error sensitivities
b = dd.b;

% plot the error sensitivity over time
numSubjects = size(b,2);
m = nanmean(b,2);
s = nanstd(b,[],2) / sqrt(numSubjects);
% the steady-state error sensitivity
bSS = mean(m(end-4:end));
subplot(2,3,4)
hold on
plot(trials,m,'-k')
plot(trials,m-s,'--k')
plot(trials,m+s,'--k')
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,20:20:60];
ylabel('error sensitivity ')
yline(bSS,'--r')
xlim([1,60])
title('Figure 3-S1D')
xlabel('cycle number')

% load the reach angles
A = dd.A;

% convert to errors
A = 30 - A;

% calculate asymptotic error
asymptote = nanmean(A(61:70,:));

subplot(2,3,5)
hold on
m = nanmean(A,2);
s = nanstd(A,[],2) / sqrt(numSubjects);
plot(1:60,m(11:70),'-k')
plot(1:60,(m(11:70)-s(11:70)),'--k')
plot(1:60,(m(11:70)+s(11:70)),'--k')
xlim([1,60])
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1,20:20:60];
m = mean(asymptote);
s = std(asymptote) / sqrt(length(asymptote));
eSSm = m;
eSSs = s;
plot([1,60],[m-s,m-s],'--c')
plot([1,60],[m+s,m+s],'--c')
plot([1,60],[m,m],'-c')
ylabel('target error (deg)')
title('Figure 3-S1E')
xlabel('cycle number')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%% compare error sensitivity to literature %%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% load the data for Kim et al. (2018) and Morehead et al. (2017)
dd = load('literature.mat');
x = dd.x1; y = dd.y1; s = dd.s1;

% plot the literature data
subplot(2,3,6)
hold on
plot(x,y,'.-k')
for n = 1 : length(x)
    plot([x(n),x(n)],[y(n)-s(n),y(n)+s(n)],'-k')
end
x = dd.x2; y = dd.y2; s = dd.s2;
plot(x,y,'.-b')
for n = 1 : length(x)
    plot([x(n),x(n)],[y(n)-s(n),y(n)+s(n)],'-b')
end
ylabel('error sensitivity')
xlabel('error (deg)')
title('Figure 3-S1F')

% plot the experimental data
plot([eSSm-eSSs,eSSm-eSSs],[0,0.6],'--c')
plot([eSSm+eSSs,eSSm+eSSs],[0,0.6],'--c')
plot([eSSm,eSSm],[0,0.6],'-c')
plot(eSSm,bSS,'rp')
ax = gca;
ax.TickDir = 'out';
ax.XTick = 0:10:40;
ax.YTick = 0:0.1:0.6;