function [] = simulatePureExplicitChange(fHandle)
% baseline parameter set
aS = 0.9829;
aF = 0.9278;
bS = 0.0629;
bF = 0.0632;

r = 30*ones(200,1);
pars = [aS;aF;bS;bF];
EC = zeros(size(r));

% base simulation
[yBase,xS1,xF1] = simulateTwoState(pars,r,EC);

figure(fHandle)
subplot(3,4,5)
hold on
plot(xS1,'-','Color',[0 128 0]/255)
plot(xF1,'-g')
ax = gca;
ax.TickDir = 'out';

%%% 0% increase implicit, 100% explicit increase
PP = pars;
PP(3) = bS;
PP(4) = bF*2;

[yExpUp,xS2,xF2] = simulateTwoState(PP,r,EC);

plot(xS2,'--','Color',[0 128 0]/255)
plot(xF2,'--g')
ylim([0,25])
xlim([1,200])
ax.XTick = [1 , 50 : 50 : 200];
ylabel('adaptive states (deg)')

subplot(3,4,9)
hold on
plot(xS2-xS1,'-m')
ylabel('implicit change (deg)')
xlabel('Trial number')
ax = gca;
ax.TickDir = 'out';
ax.XTick = [1 , 50 : 50 : 200];
ylim([-4,6])

%%%%%%%%%%%%%%% implicit only
aS = 0.9829;
aF = 0;
bS = 0.0629;
bF = 0;
pars = [aS;aF;bS;bF];

% base simulation
[yExpDown,xS3,xF3] = simulateTwoState(pars,r,EC);

subplot(3,4,6)
hold on
plot(xS1,'-r')
plot(xF1,'-','Color',[255 172 28]/255)
plot(xS3,'--r')
plot(xF3,'--','Color',[255 172 28]/255)
ax = gca;
ax.TickDir = 'out';
ylim([0,25])
xlim([1,200])
ax.XTick = [1 , 50 : 50 : 200];

subplot(3,4,10)
hold on
plot(xS3-xS1,'b')
ax = gca;
ax.TickDir = 'out';
xlim([1,200])
ax.XTick = [1 , 50 : 50 : 200];
ax.YTick = -4 : 2 : 6;
xlabel('Trial number')
ylim([-4,6])

subplot(3,4,1)
hold on
plot(yBase,'-k')
plot(yExpUp,'--k')
ax = gca;
ax.TickDir = 'out';
xlim([1,200])
ax.XTick = [1 , 50 : 50 : 200];
ylabel('overall reach angle (deg)')
title('Figure 7C')

subplot(3,4,2)
hold on
plot(yBase,'-k')
plot(yExpDown,'--k')
ax = gca;
ax.TickDir = 'out';
xlim([1,200])
ax.XTick = [1 , 50 : 50 : 200];
title('Figure 7D')