function [y,xS,xF] = simulateTwoState(pars,r,EC)
% stores input variables using descriptive names
aS = pars(1); % retention for acceleration
aF = pars(2); % retention for deceleration
bS = pars(3); % error sensitivity for acceleration
bF = pars(4); % error sensitivity for deceleration

% get the number of trials
N = length(r);

% allocate space
xS = zeros(N,1);
xF = zeros(N,1);
y = zeros(N,1); 
e = zeros(N,1);

% the initial behavior
y(1) = xS(1) + xF(1);

% the first error
e(1) = r(1) - y(1);

% iterate through all trials
for n = 2 : N
    % learning
    if EC(n-1) == 1
        % this is an error-clamp trials, so there is only decay
        xS(n) = aS*xS(n-1);
        xF(n) = aF*xF(n-1);
    else
       % left side is faster, right side is slower
        xS(n) = aS*xS(n-1) + bS*e(n-1);
        xF(n) = aF*xF(n-1) + bF*e(n-1);
    end
    
    % calculate the behavior
    y(n) = xS(n) + xF(n);
    
    % calculate the error
    e(n) = r(n) - y(n);
end

end
