function [] = figure1_supplement4()

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Experiment 1 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% load the data
dd = load('data-experiment-1.mat');
meanA = dd.meanA;
meanS = dd.meanS;

% determine explicit angles
iA = meanA;
iS = meanS;

% plot implicit stepwise
figure
subplot(1,6,1)
colors = {'k','m','b','r'};
hold on
for b = 1 : 4
    ii = iS(b,:);
    m = nanmean(ii); %#ok<*NANMEAN>
    s = nanstd(ii) / sqrt(length(ii)); %#ok<*NANSTD>
    bar(b,m,'FaceColor',colors{b},'EdgeColor','k')
    plot([b,b],[m-s,m+s],'-k')
end
ylabel('implicit adaptation (deg)')
title('Fig. 1-S4A')
ylim([0,24])

% plot implicit abrupt
subplot(1,6,2)
colors = {'k','k','k','k'};
hold on
for b = 1 : 4
    ii = iA(b,:);
    m = nanmean(ii); %#ok<*NANMEAN>
    s = nanstd(ii) / sqrt(length(ii)); %#ok<*NANSTD>
    bar(b,m,'FaceColor',colors{b},'EdgeColor','k')
    plot([b,b],[m-s,m+s],'Color',colors{b})
end
title('Fig. 1-S4B')
ylim([0,24])

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%% Salomonczyk et al. %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% load the data
dd = load('data-salomonczyk.mat');
msS = dd.msS;
ssS = dd.ssS;
msA = dd.msA;
ssA = dd.ssA;

% plot the results
subplot(1,6,3)
colors = {'k','b','r'};
hold on
for b = 1 : 3
    bar(b,msS(b),'FaceColor',colors{b},'EdgeColor','k')
    plot([b,b],[msS(b)-ssS(b),msS(b)+ssS(b)],'-k')
end
ylim([0,40])
title('Fig. 1-S4C')
subplot(1,6,4)
colors = {'k','k','k'};
hold on
for b = 1 : 3
    bar(b,msA(b),'FaceColor',colors{b},'EdgeColor','k')
    plot([b,b],[msA(b)-ssA(b),msA(b)+ssA(b)],'-k')
end
ylim([0,40])
title('Fig. 1-S4D')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%% Neville Cressman  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% load the data
dd = load('data-neville-cressman.mat');
ms20 = dd.ms20;
ss20 = dd.ss20;
ms40 = dd.ms40;
ss40 = dd.ss40;

% plot the results
subplot(1,6,5)
colors = {'k','k','k'};
hold on
for b = 1 : 3
    bar(b,ms20(b),'FaceColor',colors{b},'EdgeColor','k')
    plot([b,b],[ms20(b)-ss20(b),ms20(b)+ss20(b)],'-k')
end
ylim([0,22])
title('Fig. 1-S4E')
subplot(1,6,6)
colors = {'k','k','k'};
hold on
for b = 1 : 3
    bar(b,ms40(b),'FaceColor',colors{b},'EdgeColor','k')
    plot([b,b],[ms40(b)-ss40(b),ms40(b)+ss40(b)],'-k')
end
ylim([0,22])
title('Fig. 1-S4F')