function [J] = costfun(pars,rA,rG,xEA,xEG,eA,eG,type)

% simulate depending on type
if type == 1
    % the target error model
    [xIA,xIG] = targetErrorModel(pars,rA,rG,xEA,xEG);
else
    % the SPE model
    [xIA,xIG] = SPEModel(pars,rA,rG,xEA,xEG);
end

% determine the directional error
eAmodel = rA - xIA - xEA;
eGmodel = rG - xIG - xEG;

% clip to remove the washout period
eAmodel = eAmodel(12:46);
eGmodel = eGmodel(12:46);
eA = eA(12:46);
eG = eG(12:46);

% calculate SE
J = sum((eA - eAmodel).^2) + sum((eG - eGmodel).^2);