function [] = figure4_supplement1()

% the data and generalization curve
% note this is not "correct" because it does not correct explicit strategy
% with generalization
g = @(x,s) exp(-0.5*(x./(s)).^2);
p = 11.72/21.36;
s = sqrt((29.9^2 - 39.5^2)/(2*log(p)));
xT = 21.36 / exp(-0.5*(29.9/s)^2);
xe = linspace(0,60,1000);
ximeasure = xT*g(xe,s);

% plot the result
figure
subplot(2,4,1)
hold on
plot(xe,ximeasure,'-k','LineWidth',1)
plot([29.9,29.9],[0,21.36],'--r')
plot([39.5,39.5],[0,11.72],'--','Color',[75 54 33]/255)
plot([0,29.9],[21.36,21.36],'--r')
plot([0,39.5],[11.72,11.72],'--','Color',[75 54 33]/255)
plot(29.9,21.36,'.r','MarkerSize',20)
plot(39.5,11.72,'.','Color',[75 54 33]/255,'MarkerSize',20)
ax = gca;
ax.TickDir = 'out';
ylabel('measured implicit (deg)')
xlabel('measured explicit (deg)')
title('Figure 4-S1A')

% show the contradiction
% without correcting explicit strategy, total learning is not physical
subplot(2,4,2)
mA = 54.9531;
sA = 0.9029;
mS = 51.3023;
sS = 0.6299;

hold on
bar(1,39.5+xT,'FaceColor',[75 54 33]/255,'EdgeColor','k')
bar(2,mA,'FaceColor',[75 54 33]/255,'EdgeColor','k')
plot([2,2],[mA-sA,mA+sA],'Color','k')
bar(4,29.9+xT,'FaceColor','r','EdgeColor','k')
plot([0,6],[60,60],'-k')
bar(5,mS,'FaceColor','r','EdgeColor','k')
plot([5,5],[mS-sS,mS+sS],'Color','k')

ax = gca;
ax.TickDir = 'out';
ylabel('total adaptation (deg)')
title('Figure 4-S1B')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%% Neville and Cressman analysis %%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% the Neville and Cressman Data (N no strat and Y is strat)
xeN = 19.7675;
xeY = 30.7710;
xiN = 9.4475;
xiY = 6.4640;

% get the scaling factor (b/1-a+b)
fun = @(p,xI,xE,r,sigma) sum((xI - xIGauss(xE,p,r,sigma)).^2);

% fit options
options = optimset('display','none');

% the data to fit
i = [xiN,xiY];
e = [xeN,xeY];
r = [40,40];

% get the scaling factor (b/1-a+b)
pars = fmincon(@(pars)fun(pars(1),i,e,r,pars(2)),[0.2,4],[],[],[],[],...
    [0.5,0],[1,120],[],options);
p = pars(1);
sigma = pars(2);

% true strategy
ee = linspace(0,120,300);
ii = xIGauss22(ee,p,40*ones(size(ee)),sigma);
subplot(2,4,7)
hold on
plot(ee,ii,'-m','LineWidth',1)
plot(e(1),i(1),'.k','MarkerSize',20)
plot(e(2),i(2),'.m','MarkerSize',20)
xlabel('estimated explicit (deg)')
ylabel('measured implicit (deg)')
plot([0,e(1)],[i(1),i(1)],'--k')
plot([0,e(2)],[i(2),i(2)],'--m')
plot([e(1),e(1)],[0,i(1)],'--k')
plot([e(2),e(2)],[0,i(2)],'--m')
title('Figure 4-S1G')

% plot the gauss generalization curve with same total adaptation
subplot(2,4,8)
hold on
% the generalization function
xi = p*40*exp(-0.5*(ee/sigma).^2)/(40*p)*100;
plot(ee,xi,'-m')
ax = gca;
ax.TickDir = 'out';

% load literature generalization curves
d = load('data-literature.mat');
MCXm = d.MCXm1; MCYm = d.MCYm1; MCYs = d.MCYs1;
plot(MCXm,MCYm,'-','Color',[205,127,50]/255)
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color',[205,127,50]/255)
end

MCXm = d.MCXm2; MCYm = d.MCYm2; MCYs = d.MCYs2;
plot(MCXm,MCYm,'-','Color','m')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','m')
end

MCXm = d.MCXm3; MCYm = d.MCYm3; MCYs = d.MCYs3;
plot(MCXm,MCYm,'-','Color','b')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','b')
end

MCXm = d.MCXm4; MCYm = d.MCYm4; MCYs = d.MCYs4;
plot(MCXm,MCYm,'-','Color','g')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','g')
end

MCXm = d.MCXm5; MCYm = d.MCYm5; MCYs = d.MCYs5;
plot(MCXm,MCYm,'-','Color','r')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','r')
end

MCXm = d.MCXm6; MCYm = d.MCYm6; MCYs = d.MCYs6;
plot(MCXm,MCYm,'-','Color','c')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','c')
end

ax = gca;
ax.TickDir = 'out';
ylabel('measured implicit (% total)')
xlabel('total explicit (deg)')
ax.YTick = 0:20:120;
ax.XTick = 0:20:120;
title('Figure 4-S1H')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% the response to the 20, 40, and 60 degree rotations
xi20 = 10.0814;
xe20 = 6.4249;
xi40 = 9.7576;
xe40 = 26.3924;
xi60 = 8.4398;
xe60 = 44.3711;

% fit options
options = optimset('display','none');

% the data to fit
i = [xi20,xi40,xi60];
e = [xe20,xe40,xe60];
r = [20,40,60];

% get the scaling factor (b/1-a+b)
pars = fmincon(@(pars)fun(pars(1),i,e,r,pars(2)),[0.2,4],[],[],[],[],...
    [0,0],[1,120],[],options);
p = pars(1);
sigma = pars(2);

% plot the results
subplot(2,4,5)
hold on
ee = linspace(0,120,350);
ii = xIGauss22(ee,p,20*ones(size(ee)),sigma);
plot(ee,ii,'-k','LineWidth',1)
ii = xIGauss22(ee,p,40*ones(size(ee)),sigma);
plot(ee,ii,'-b','LineWidth',1)
ii = xIGauss22(ee,p,60*ones(size(ee)),sigma);
plot(ee,ii,'-r','LineWidth',1)
plot(e(1),i(1),'.k','MarkerSize',20)
plot(e(2),i(2),'.b','MarkerSize',20)
plot(e(3),i(3),'.r','MarkerSize',20)
plot([0,e(1)],[i(1),i(1)],'--k')
plot([0,e(2)],[i(2),i(2)],'--b')
plot([0,e(3)],[i(3),i(3)],'--r')
plot([e(1),e(1)],[0,i(1)],'--k')
plot([e(2),e(2)],[0,i(2)],'--b')
plot([e(3),e(3)],[0,i(3)],'--r')

ax = gca;
ax.TickDir = 'out';
ylabel('measured implicit (deg)')
xlabel('estimated explicit (deg)')
title('Figure 4-S1E')

% the generalization function
subplot(2,4,6)
hold on
ee = linspace(0,120,350);
xi = p*20*exp(-0.5*(ee/sigma).^2) / (p*20) * 100;
plot(ee,xi,'-m')

% load literature generalization curves
d = load('data-literature.mat');
MCXm = d.MCXm1; MCYm = d.MCYm1; MCYs = d.MCYs1;
plot(MCXm,MCYm,'-','Color',[205,127,50]/255)
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color',[205,127,50]/255)
end

MCXm = d.MCXm2; MCYm = d.MCYm2; MCYs = d.MCYs2;
plot(MCXm,MCYm,'-','Color','m')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','m')
end

MCXm = d.MCXm3; MCYm = d.MCYm3; MCYs = d.MCYs3;
plot(MCXm,MCYm,'-','Color','b')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','b')
end

MCXm = d.MCXm4; MCYm = d.MCYm4; MCYs = d.MCYs4;
plot(MCXm,MCYm,'-','Color','g')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','g')
end

MCXm = d.MCXm5; MCYm = d.MCYm5; MCYs = d.MCYs5;
plot(MCXm,MCYm,'-','Color','r')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','r')
end

MCXm = d.MCXm6; MCYm = d.MCYm6; MCYs = d.MCYs6;
plot(MCXm,MCYm,'-','Color','c')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','c')
end

ax = gca;
ax.TickDir = 'out';
ylabel('measured implicit (% total)')
xlabel('total explicit (deg)')
ax.YTick = 0:20:120;
ax.XTick = 0:20:120;
title('Figure 4-S1F')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% abrupt vs stepwise analysis %%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% the stepwise and abrupt data
xiS = 21.36;
xiA = 11.72;
xeS = 29.9;
xeA = 39.5;

% get the scaling factor (b/1-a+b)
fun = @(p,xI,xE,r,sigma) sum((xI - xIGauss(xE,p,r,sigma)).^2);

% fit options
options = optimset('display','none');

% the data to fit
i = [xiS,xiA];
e = [xeS,xeA];
r = [60,60];

% get the scaling factor (b/1-a+b)
pars = fmincon(@(pars)fun(pars(1),i,e,r,pars(2)),[0.2,4],[],[],[],[],...
    [0,0],[1,120],[],options);
p = pars(1);
sigma = pars(2);

subplot(2,4,3)
hold on

% true strategy
ee = linspace(0,90,250);
ii = xIGauss22(ee,p,60*ones(size(ee)),sigma);
plot(ee,ii,'-m','LineWidth',1)
plot(e(1),i(1),'.r','MarkerSize',20)
plot(e(2),i(2),'.','Color',[75 54 33]/255,'MarkerSize',20)
plot([0,e(1)],[i(1),i(1)],'--r')
plot([0,e(2)],[i(2),i(2)],'--','Color',[75 54 33]/255)
plot([e(1),e(1)],[0,i(1)],'--r')
plot([e(2),e(2)],[0,i(2)],'--','Color',[75 54 33]/255)

ax = gca;
ax.TickDir = 'out';
ylabel('measured implicit (deg)')
xlabel('estimated explicit (deg)')
title('Figure 4-S1C')

% the generalization function
subplot(2,4,4)
hold on
xi = p*60*exp(-0.5*(ee/sigma).^2)/(p*60)*100;
plot(ee,xi,'-m')

% load literature generalization curves
d = load('data-literature.mat');
MCXm = d.MCXm1; MCYm = d.MCYm1; MCYs = d.MCYs1;
plot(MCXm,MCYm,'-','Color',[205,127,50]/255)
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color',[205,127,50]/255)
end

MCXm = d.MCXm2; MCYm = d.MCYm2; MCYs = d.MCYs2;
plot(MCXm,MCYm,'-','Color','m')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','m')
end

MCXm = d.MCXm3; MCYm = d.MCYm3; MCYs = d.MCYs3;
plot(MCXm,MCYm,'-','Color','b')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','b')
end

MCXm = d.MCXm4; MCYm = d.MCYm4; MCYs = d.MCYs4;
plot(MCXm,MCYm,'-','Color','g')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','g')
end

MCXm = d.MCXm5; MCYm = d.MCYm5; MCYs = d.MCYs5;
plot(MCXm,MCYm,'-','Color','r')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','r')
end

MCXm = d.MCXm6; MCYm = d.MCYm6; MCYs = d.MCYs6;
plot(MCXm,MCYm,'-','Color','c')
for i = 1 : length(MCXm)
    plot([MCXm(i),MCXm(i)],[MCYm(i)-MCYs(i),MCYm(i)+MCYs(i)],'-','Color','c')
end

ax = gca;
ax.TickDir = 'out';
ylabel('measured implicit (% total)')
xlabel('total explicit (deg)')
ax.YTick = 0:20:120;
ax.XTick = 0:20:120;
title('Figure 4-S1D')
